/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.Binding1;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.lib.Lib;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.BindingNodeId;
import com.hp.hpl.jena.tdb.solver.BindingTDB;
import com.hp.hpl.jena.tdb.solver.QueryIterTDB;
import com.hp.hpl.jena.tdb.solver.StageMatchTuple;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverLib {
    private static Logger log = LoggerFactory.getLogger(SolverLib.class);
    public static final ConvertNodeIDToNode converter = new ConvertNodeIDToNode(){

        @Override
        public Iterator<Binding> convert(NodeTable nodeTable, Iterator<BindingNodeId> iterBindingIds) {
            return Iter.map(iterBindingIds, (Transform)SolverLib.convToBinding(nodeTable));
        }
    };

    public static QueryIterator execute(GraphTDB graph, BasicPattern pattern, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        return SolverLib.execute(graph.getNodeTupleTable(), null, pattern, input, filter, execCxt);
    }

    public static QueryIterator execute(DatasetGraphTDB ds, Node graphNode, BasicPattern pattern, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        return SolverLib.execute(ds.getQuadTable().getNodeTupleTable(), graphNode, pattern, input, filter, execCxt);
    }

    public static Iterator<BindingNodeId> convertToIds(Iterator<Binding> iterBindings, NodeTable nodeTable) {
        return Iter.map(iterBindings, SolverLib.convFromBinding(nodeTable));
    }

    public static Iterator<Binding> convertToNodes(Iterator<BindingNodeId> iterBindingIds, NodeTable nodeTable) {
        return Iter.map(iterBindingIds, SolverLib.convToBinding(nodeTable));
    }

    private static QueryIterator execute(NodeTupleTable nodeTupleTable, Node graphNode, BasicPattern pattern, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        List triples = pattern.getList();
        boolean anyGraph = graphNode == null ? false : Node.ANY.equals((Object)graphNode);
        int tupleLen = nodeTupleTable.getTupleTable().getTupleLen();
        if (graphNode == null) {
            if (3 != tupleLen) {
                throw new TDBException("SolverLib: Null graph node but tuples are of length " + tupleLen);
            }
        } else if (4 != tupleLen) {
            throw new TDBException("SolverLib: Graph node specified but tuples are of length " + tupleLen);
        }
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Iterator<BindingNodeId> chain = Iter.map((Iterator)input, SolverLib.convFromBinding(nodeTable));
        for (Triple triple : triples) {
            Tuple tuple = null;
            tuple = graphNode == null ? Tuple.create((Object[])new Node[]{triple.getSubject(), triple.getPredicate(), triple.getObject()}) : Tuple.create((Object[])new Node[]{graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject()});
            chain = SolverLib.solve(nodeTupleTable, (Tuple<Node>)tuple, anyGraph, chain, filter, execCxt);
        }
        Iterator<Binding> iterBinding = converter.convert(nodeTable, chain);
        return new QueryIterTDB(iterBinding, input, execCxt);
    }

    private static Iterator<BindingNodeId> solve(NodeTupleTable nodeTupleTable, Tuple<Node> tuple, boolean anyGraph, Iterator<BindingNodeId> chain, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        return new StageMatchTuple(nodeTupleTable, chain, tuple, anyGraph, filter, execCxt);
    }

    private static Transform<BindingNodeId, Binding> convToBinding(final NodeTable nodeTable) {
        return new Transform<BindingNodeId, Binding>(){

            public Binding convert(BindingNodeId bindingNodeIds) {
                return SolverLib.convToBinding(nodeTable, bindingNodeIds);
            }
        };
    }

    public static Binding convToBinding(NodeTable nodeTable, BindingNodeId bindingNodeIds) {
        return new BindingTDB(bindingNodeIds, nodeTable);
    }

    private static Transform<Binding, BindingNodeId> convFromBinding(final NodeTable nodeTable) {
        return new Transform<Binding, BindingNodeId>(){

            public BindingNodeId convert(Binding binding) {
                if (binding instanceof BindingTDB) {
                    return ((BindingTDB)binding).getBindingId();
                }
                BindingNodeId b = new BindingNodeId(binding);
                Iterator vars = binding.vars();
                while (vars.hasNext()) {
                    NodeId id;
                    Var v = (Var)vars.next();
                    Node n = binding.get(v);
                    if (n == null || NodeId.doesNotExist(id = nodeTable.getNodeIdForNode(n))) continue;
                    b.put(v, id);
                }
                return b;
            }
        };
    }

    public static QueryIterator graphNames(DatasetGraphTDB ds, Node graphNode, QueryIterator input, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        Iterator iter1 = ds.getQuadTable().getNodeTupleTable().find(NodeId.NodeIdAny, NodeId.NodeIdAny, NodeId.NodeIdAny, NodeId.NodeIdAny);
        if (filter != null) {
            iter1 = Iter.filter(iter1, filter);
        }
        Iterator iter2 = Tuple.project((int)0, iter1);
        Iterator iter3 = Iter.distinct((Iterator)iter2);
        Iterator<Node> iter4 = NodeLib.nodes(ds.getQuadTable().getNodeTupleTable().getNodeTable(), iter3);
        final Var var = Var.alloc((Node)graphNode);
        Transform<Node, Binding> bindGraphName = new Transform<Node, Binding>(){

            public Binding convert(Node node) {
                return new Binding1(null, var, node);
            }
        };
        Iterator iterBinding = Iter.map(iter4, (Transform)bindGraphName);
        return new QueryIterTDB(iterBinding, input, execCxt);
    }

    public static String strPattern(BasicPattern pattern) {
        List triples = pattern.getList();
        String x = Iter.asString((Iterable)triples, (String)"\n  ");
        return Lib.printAbbrev(x);
    }

    public static Set<Node> convertToNodes(Collection<String> uris) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (String x : uris) {
            nodes.add(Node.createURI((String)x));
        }
        return nodes;
    }

    public static Set<NodeId> convertToNodeIds(Collection<Node> nodes, DatasetGraphTDB dataset) {
        HashSet<NodeId> graphIds = new HashSet<NodeId>();
        NodeTable nt = dataset.getQuadTable().getNodeTupleTable().getNodeTable();
        for (Node n : nodes) {
            graphIds.add(nt.getNodeIdForNode(n));
        }
        return graphIds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConvertNodeIDToNode {
        public Iterator<Binding> convert(NodeTable var1, Iterator<BindingNodeId> var2);
    }
}

