/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.TDB;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;

public class Explain {
    public static final Logger logExec = TDB.logExec;
    public static final Logger logInfo = TDB.logInfo;
    public static final Symbol symLogExec = TDB.symLogExec;

    public static void explain(Query query, Context context) {
        Explain.explain("Query", query, context);
    }

    public static void explain(String message, Query query, Context context) {
        if (Explain.explaining(InfoLevel.INFO, logExec, context)) {
            IndentedLineBuffer iBuff = new IndentedLineBuffer();
            query.serialize(iBuff);
            String x = iBuff.asString();
            Explain._explain(logExec, message, x, true);
        }
    }

    public static void explain(Op op, Context context) {
        Explain.explain("Algebra", op, context);
    }

    public static void explain(String message, Op op, Context context) {
        if (Explain.explaining(InfoLevel.FINE, logExec, context)) {
            Explain._explain(logExec, message, op.toString(), true);
        }
    }

    public static void explain(BasicPattern bgp, Context context) {
        Explain.explain("BGP", bgp, context);
    }

    public static void explain(String message, BasicPattern bgp, Context context) {
        if (Explain.explaining(InfoLevel.ALL, logExec, context)) {
            Explain._explain(logExec, message, bgp.toString(), false);
        }
    }

    public static void explain(String message, QuadPattern quads, Context context) {
        if (Explain.explaining(InfoLevel.ALL, logExec, context)) {
            String str = Explain.formatQuads(quads);
            Explain._explain(logExec, message, str, false);
        }
    }

    private static String formatQuads(QuadPattern quads) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        SerializationContext sCxt = SSE.sCxt((PrefixMapping)SSE.defaultPrefixMapWrite);
        boolean first = true;
        for (Quad qp : quads) {
            if (!first) {
                out.print((Object)" ");
            } else {
                first = false;
            }
            out.print((Object)"(");
            WriterNode.output((IndentedWriter)out, (Node)qp.getGraph(), (SerializationContext)sCxt);
            out.print((Object)" ");
            WriterNode.output((IndentedWriter)out, (Node)qp.getSubject(), (SerializationContext)sCxt);
            out.print((Object)" ");
            WriterNode.output((IndentedWriter)out, (Node)qp.getPredicate(), (SerializationContext)sCxt);
            out.print((Object)" ");
            WriterNode.output((IndentedWriter)out, (Node)qp.getObject(), (SerializationContext)sCxt);
            out.print((Object)")");
        }
        out.flush();
        return out.toString();
    }

    private static void _explain(Logger logger, String reason, String explanation, boolean newlineAlways) {
        while (explanation.endsWith("\n") || explanation.endsWith("\r")) {
            explanation = StrUtils.chop((String)explanation);
        }
        explanation = newlineAlways || explanation.contains("\n") ? reason + "\n" + explanation : reason + " :: " + explanation;
        Explain._explain(logger, explanation);
    }

    private static void _explain(Logger logger, String explanation) {
        logger.info(explanation);
    }

    public static void explain(Context context, String message) {
        if (Explain.explaining(InfoLevel.INFO, logInfo, context)) {
            Explain._explain(logInfo, message);
        }
    }

    public static void explain(Context context, String format, Object ... args) {
        if (Explain.explaining(InfoLevel.INFO, logInfo, context)) {
            String str = String.format(format, args);
            Explain._explain(logInfo, str);
        }
    }

    public static boolean explaining(InfoLevel level, Logger logger, Context context) {
        if (!Explain._explaining(level, context)) {
            return false;
        }
        return logger.isInfoEnabled();
    }

    private static boolean _explaining(InfoLevel level, Context context) {
        if (level == InfoLevel.NONE) {
            return false;
        }
        Object x = context.get(symLogExec, null);
        if (x == null) {
            return false;
        }
        if (level.level() == InfoLevel.NONE.level()) {
            return false;
        }
        if (x instanceof InfoLevel) {
            InfoLevel z = (InfoLevel)((Object)x);
            if (z == InfoLevel.NONE) {
                return false;
            }
            return z.level() >= level.level();
        }
        if (x instanceof String) {
            String s = (String)x;
            if (s.equalsIgnoreCase("info")) {
                return level.equals((Object)InfoLevel.INFO);
            }
            if (s.equalsIgnoreCase("fine")) {
                return level.equals((Object)InfoLevel.FINE) || level.equals((Object)InfoLevel.INFO);
            }
            if (s.equalsIgnoreCase("all")) {
                return true;
            }
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("none")) {
                return false;
            }
        }
        return Boolean.TRUE.equals(x);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InfoLevel {
        INFO{

            public int level() {
                return 1;
            }
        }
        ,
        FINE{

            public int level() {
                return 2;
            }
        }
        ,
        ALL{

            public int level() {
                return 3;
            }
        }
        ,
        NONE{

            public int level() {
                return -1;
            }
        };


        public abstract int level();
    }
}

