/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.lib.NodeFmtLib;
import com.hp.hpl.jena.tdb.nodetable.Nodec;
import java.nio.ByteBuffer;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.Pool;
import org.openjena.atlas.lib.PoolSync;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class NodecSSE
implements Nodec {
    private static boolean SafeChars = false;
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};
    static int poolBufferSize = 1000;
    static int poolSize = 2;
    private static final Pool<ByteBuffer> buffers = new PoolSync();

    public ByteBuffer alloc(Node node) {
        return ByteBuffer.allocate(NodecSSE.maxLength(node));
    }

    public void release(ByteBuffer bb) {
    }

    public int encode(Node node, ByteBuffer bb, PrefixMapping pmap) {
        String x;
        if (node.isURI() && (x = StrUtils.encode((String)node.getURI(), (char)'_', (char[])invalidIRIChars)) != node.getURI()) {
            node = Node.createURI((String)x);
        }
        String str = NodeFmtLib.serialize(node);
        int x2 = Bytes.toByteBuffer((CharSequence)str, (ByteBuffer)bb);
        bb.position(0);
        bb.limit(x2);
        return x2;
    }

    public Node decode(ByteBuffer bb, PrefixMapping pmap) {
        String str = Bytes.fromByteBuffer((ByteBuffer)bb);
        if (str.startsWith("_:")) {
            str = str.substring(2);
            return Node.createAnon((AnonId)new AnonId(str));
        }
        if (str.startsWith("<")) {
            str = str.substring(1, str.length() - 1);
            str = StrUtils.decode((String)str, (char)'_');
            return Node.createURI((String)str);
        }
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)str);
        Node n = tokenizer.next().asNode();
        if (n == null) {
            throw new TDBException("Not a node: " + str);
        }
        return n;
    }

    private static int maxLength(Node node) {
        if (node.isBlank()) {
            return 2 + NodecSSE.maxLength(node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            return 2 + NodecSSE.maxLength(node.getURI());
        }
        if (node.isLiteral()) {
            if (node.getLiteralDatatypeURI() != null) {
                return 6 + NodecSSE.maxLength(node.getLiteralLexicalForm()) + NodecSSE.maxLength(node.getLiteralDatatypeURI());
            }
            if (node.getLiteralLanguage() != null) {
                return 3 + NodecSSE.maxLength(node.getLiteralLexicalForm()) + node.getLiteralLanguage().length();
            }
            return 2 + NodecSSE.maxLength(node.getLiteralLexicalForm());
        }
        if (node.isVariable()) {
            return 1 + NodecSSE.maxLength(node.getName());
        }
        throw new TDBException("Unrecognized node type: " + node);
    }

    private static int maxLength(String string) {
        return string.length() * 3;
    }

    static {
        for (int i = 0; i < poolSize; ++i) {
            buffers.put((Object)ByteBuffer.allocate(poolBufferSize));
        }
    }
}

