/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.Hash;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTableNative
implements NodeTable {
    protected ObjectFile objects;
    protected Index nodeHashToId;

    protected NodeTableNative() {
    }

    public NodeTableNative(Index nodeToId, ObjectFile objectFile) {
        this();
        this.init(nodeToId, objectFile);
    }

    protected void init(Index nodeToId, ObjectFile objectFile) {
        this.nodeHashToId = nodeToId;
        this.objects = objectFile;
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        return this._retrieveNodeByNodeId(id);
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        return this._idForNode(node, false);
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        return this._idForNode(node, true);
    }

    private Node _retrieveNodeByNodeId(NodeId id) {
        if (NodeId.doesNotExist(id)) {
            return null;
        }
        if (NodeId.isAny(id)) {
            return null;
        }
        Node n = this.readNodeByNodeId(id);
        return n;
    }

    private NodeId _idForNode(Node node, boolean allocate) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        NodeId nodeId = NodeId.inline(node);
        if (nodeId != null) {
            return nodeId;
        }
        nodeId = this.accessIndex(node, allocate);
        return nodeId;
    }

    protected NodeId accessIndex(Node node, boolean create) {
        Hash hash = new Hash(this.nodeHashToId.getRecordFactory().keyLength());
        NodeLib.setHash(hash, node);
        byte[] k = hash.getBytes();
        Record r = this.nodeHashToId.getRecordFactory().create(k);
        Record r2 = this.nodeHashToId.find(r);
        if (r2 != null) {
            NodeId id = NodeId.create(r2.getValue(), 0);
            return id;
        }
        if (!create) {
            return NodeId.NodeDoesNotExist;
        }
        NodeId id = this.writeNodeToTable(node);
        id.toBytes(r.getValue(), 0);
        if (!this.nodeHashToId.add(r)) {
            throw new TDBException("NodeTableBase::nodeToId - record mysteriously appeared");
        }
        return id;
    }

    protected final NodeId writeNodeToTable(Node node) {
        long x = NodeLib.encodeStore(node, this.getObjects());
        return NodeId.create(x);
    }

    protected final Node readNodeByNodeId(NodeId id) {
        return NodeLib.fetchDecode(id.getId(), this.getObjects());
    }

    public synchronized void close() {
        if (this.nodeHashToId != null) {
            this.nodeHashToId.close();
            this.nodeHashToId = null;
        }
        if (this.getObjects() != null) {
            this.getObjects().close();
            this.objects = null;
        }
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        Iterator<Record> iter = this.nodeHashToId.iterator();
        Transform<Record, Pair<NodeId, Node>> transform = new Transform<Record, Pair<NodeId, Node>>(){

            public Pair<NodeId, Node> convert(Record item) {
                NodeId id = NodeId.create(item.getValue(), 0);
                Node n = NodeLib.fetchDecode(id.getId(), NodeTableNative.this.getObjects());
                return new Pair((Object)id, (Object)n);
            }
        };
        return Iter.map(iter, (Transform)transform);
    }

    public void sync() {
        this.sync(true);
    }

    public synchronized void sync(boolean force) {
        if (this.nodeHashToId != null) {
            this.nodeHashToId.sync(force);
        }
        if (this.getObjects() != null) {
            this.getObjects().sync(force);
        }
    }

    public ObjectFile getObjects() {
        return this.objects;
    }
}

