/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.modify;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorFactory;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorRegistry;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorVisitor;
import com.hp.hpl.jena.sparql.modify.UpdateVisitor;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;

public class UpdateProcessorTDB
implements UpdateProcessor {
    DatasetGraphTDB graphStore;
    UpdateRequest request;
    Binding inputBinding;

    public UpdateProcessorTDB(DatasetGraphTDB graphStore, UpdateRequest request, Binding inputBinding) {
        this.graphStore = graphStore;
        this.request = request;
        this.inputBinding = inputBinding;
    }

    public void execute() {
        this.graphStore.startRequest();
        UpdateProcessorVisitor v = new UpdateProcessorVisitor((GraphStore)this.graphStore, this.inputBinding);
        for (Update update : this.request.getUpdates()) {
            update.visit((UpdateVisitor)v);
        }
        this.graphStore.finishRequest();
    }

    public static UpdateProcessorFactory getFactory() {
        return new UpdateProcessorFactory(){

            public boolean accept(UpdateRequest request, GraphStore graphStore) {
                return graphStore instanceof DatasetGraphTDB;
            }

            public UpdateProcessor create(UpdateRequest request, GraphStore graphStore, Binding inputBinding) {
                return new UpdateProcessorTDB((DatasetGraphTDB)graphStore, request, inputBinding);
            }
        };
    }

    public static void register() {
        UpdateProcessorRegistry.get().add(UpdateProcessorTDB.getFactory());
    }
}

