/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.mem;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.iterator.IteratorConcat;
import org.openjena.atlas.lib.DS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexMultiValue<K, V> {
    private Map<K, Set<V>> map = DS.map();

    public Set<V> get(K key) {
        return this.map.get(key);
    }

    public void put(K key, V value) {
        Set x = this.map.get(key);
        if (x == null) {
            x = DS.set();
            this.map.put(key, x);
        }
        if (!x.contains(value)) {
            x.add(value);
        }
    }

    public Iterator<V> flatten() {
        IteratorConcat all = new IteratorConcat();
        for (K k : this.map.keySet()) {
            Set<V> x = this.map.get(k);
            all.add(x.iterator());
        }
        return all;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

