/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.mem;

import com.hp.hpl.jena.tdb.index.mem.Index;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.iterator.IteratorConcat;
import org.openjena.atlas.lib.DS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index3<K1, K2, K3, V> {
    private Map<K1, Index<K2, Index<K3, V>>> map = DS.map();

    public Index<K2, Index<K3, V>> get(K1 key1) {
        return this.map.get(key1);
    }

    public Index<K3, V> get(K1 key1, K2 key2) {
        Index<K2, Index<K3, V>> x = this.get(key1);
        if (x == null) {
            return null;
        }
        return x.get(key2);
    }

    public V get(K1 key1, K2 key2, K3 key3) {
        Index<K3, V> x = this.get(key1, key2);
        if (x == null) {
            return null;
        }
        return x.get(key3);
    }

    private Index<K3, V> seek(K1 key1, K2 key2, K3 key3) {
        Index<Object, V> z;
        Index<Object, Index<Object, V>> x = this.map.get(key1);
        if (x == null) {
            x = new Index();
            this.map.put(key1, x);
        }
        if ((z = x.get(key2)) == null) {
            z = new Index();
            x.put(key2, z);
        }
        return z;
    }

    public boolean put(K1 key1, K2 key2, K3 key3, V value) {
        Index<K3, V> z = this.seek(key1, key2, key3);
        return z.put(key3, value);
    }

    public boolean remove(K1 key1, K2 key2, K3 key3) {
        Index<K3, V> z = this.get(key1, key2);
        if (z == null) {
            return false;
        }
        return z.remove(key3);
    }

    public Iterator<V> flatten() {
        IteratorConcat all = new IteratorConcat();
        for (K1 k1 : this.keys()) {
            Index<K2, Index<K3, V>> x = this.get(k1);
            for (K2 k2 : x.keys()) {
                Index<K3, V> y = x.get(k2);
                all.add(y.values().iterator());
            }
        }
        return all;
    }

    public Set<K1> keys() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

