/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.index.mem.Index;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openjena.atlas.iterator.IteratorConcat;
import org.openjena.atlas.lib.DS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index2<K1, K2, V> {
    private Map<K1, Index<K2, List<V>>> map = DS.map();

    public Index<K2, List<V>> get(Node key1) {
        return this.map.get(key1);
    }

    public List<V> get(K1 key1, K2 key2) {
        return this.map.get(key1).get(key2);
    }

    public void put(K1 key1, K2 key2, V value) {
        List z;
        Index<Object, List<V>> x = this.map.get(key1);
        if (x == null) {
            x = new Index();
            this.map.put(key1, x);
        }
        if ((z = x.get(key2)) == null) {
            z = DS.list();
            x.put(key2, z);
        }
        z.add(value);
    }

    public void remove(K1 key1, K2 key2) {
        Index<K2, List<V>> x = this.map.get(key1);
        if (x == null) {
            return;
        }
        x.remove(key2);
    }

    public Iterator<V> flatten() {
        IteratorConcat all = new IteratorConcat();
        for (K1 k1 : this.map.keySet()) {
            Index<K2, List<V>> x = this.map.get(k1);
            for (K2 k2 : x.keys()) {
                List<V> y = x.get(k2);
                all.add(y.iterator());
            }
        }
        return all;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

