/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockConverter;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockType;
import com.hp.hpl.jena.tdb.base.buffer.PtrBuffer;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeException;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNode;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreePage;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreePageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecords;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import java.nio.ByteBuffer;

public final class BPTreeNodeMgr
extends BPTreePageMgr {
    private BlockMgr blockMgr;
    private Block2BPTreeNode converter;

    public BPTreeNodeMgr(BPlusTree bpTree, BlockMgr blockMgr) {
        super(bpTree);
        this.blockMgr = blockMgr;
        this.converter = new Block2BPTreeNode();
    }

    public BlockMgr getBlockMgr() {
        return this.blockMgr;
    }

    public int allocateId() {
        return this.blockMgr.allocateId();
    }

    public BPTreeNode createRoot() {
        int recId = this.bpTree.getRecordsMgr().allocateId();
        BPTreeRecords page = this.bpTree.getRecordsMgr().create(recId);
        ((BPTreePage)page).put();
        BPTreeNode n = this.createNode(-2);
        n.ptrs.setSize(0);
        n.ptrs.add(page.getId());
        n.isLeaf = true;
        n.setCount(0);
        n.put();
        return n;
    }

    public BPTreeNode createNode(int parent) {
        int id = this.blockMgr.allocateId();
        ByteBuffer bb = this.blockMgr.allocateBuffer(id);
        BPTreeNode n = this.converter.createFromByteBuffer(bb, BlockType.BPTREE_BRANCH);
        n.setId(id);
        n.isLeaf = false;
        n.parent = parent;
        return n;
    }

    public BPTreeNode getRoot(int id) {
        return this.get(id, -2);
    }

    public BPTreeNode get(int id, int parent) {
        ByteBuffer bb = this.blockMgr.get(id);
        BPTreeNode n = this.converter.fromByteBuffer(bb);
        n.setId(id);
        n.parent = parent;
        return n;
    }

    public void put(BPTreeNode node) {
        ByteBuffer bb = this.converter.toByteBuffer(node);
        this.blockMgr.put(node.getId(), bb);
    }

    public void release(int id) {
        this.blockMgr.freeBlock(id);
    }

    public boolean valid(int id) {
        return this.blockMgr.valid(id);
    }

    public void dump() {
        int idx = 0;
        while (this.valid(idx)) {
            BPTreeNode n = this.get(idx, -99);
            System.out.println(n);
            ++idx;
        }
    }

    public void startRead() {
        this.blockMgr.startRead();
    }

    public void finishRead() {
        this.blockMgr.finishRead();
    }

    public void startUpdate() {
        this.blockMgr.startUpdate();
    }

    public void finishUpdate() {
        this.blockMgr.finishUpdate();
    }

    private static final BlockType getType(int x) {
        return BlockType.extract(x >>> 24);
    }

    private static final int encodeCount(BlockType type, int i) {
        return type.id() << 24 | i & 0xFFFFFF;
    }

    private static final int decodeCount(int i) {
        return i & 0xFFFFFF;
    }

    private static BPTreeNode overlay(BPlusTree bpTree, ByteBuffer byteBuffer, boolean asLeaf, int count) {
        BPTreeNode n = new BPTreeNode(bpTree, -1, byteBuffer);
        BPTreeNodeMgr.formatBPTreeNode(n, bpTree, byteBuffer, asLeaf, count);
        return n;
    }

    static BPTreeNode formatBPTreeNode(BPTreeNode n, BPlusTree bTree, ByteBuffer byteBuffer, boolean leaf, int count) {
        int header;
        BPlusTreeParams params = bTree.getParams();
        int ptrBuffLen = params.MaxPtr * params.getPtrLength();
        int recBuffLen = params.MaxRec * params.getRecordLength();
        n.setId(-1);
        n.parent = -2;
        n.setCount(count);
        n.isLeaf = leaf;
        int rStart = header = BPlusTreeParams.BlockHeaderSize;
        int pStart = header + recBuffLen;
        int numPtrs = -1;
        if (n.getCount() < 0) {
            numPtrs = 0;
            n.setCount(BPTreeNodeMgr.decodeCount(n.getCount()));
        } else {
            numPtrs = n.getCount() + 1;
        }
        n.getBackingByteBuffer().position(rStart);
        n.getBackingByteBuffer().limit(rStart + recBuffLen);
        ByteBuffer bbr = n.getBackingByteBuffer().slice();
        n.records = new RecordBuffer(bbr, n.params.keyFactory, n.getCount());
        n.getBackingByteBuffer().position(pStart);
        n.getBackingByteBuffer().limit(pStart + ptrBuffLen);
        ByteBuffer bbi = n.getBackingByteBuffer().slice();
        n.ptrs = new PtrBuffer(bbi, numPtrs);
        n.getBackingByteBuffer().rewind();
        return n;
    }

    static final void formatForRoot(BPTreeNode n, boolean asLeaf) {
        BPTreeNodeMgr.formatBPTreeNode(n, n.bpTree, n.getBackingByteBuffer(), asLeaf, 0);
        n.setId(0);
        n.parent = -2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Block2BPTreeNode
    implements BlockConverter.Converter<BPTreeNode> {
        private Block2BPTreeNode() {
        }

        @Override
        public BPTreeNode createFromByteBuffer(ByteBuffer bb, BlockType bType) {
            return BPTreeNodeMgr.overlay(BPTreeNodeMgr.this.bpTree, bb, bType == BlockType.RECORD_BLOCK, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BPTreeNode fromByteBuffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                int x = byteBuffer.getInt(0);
                BlockType type = BPTreeNodeMgr.getType(x);
                if (type != BlockType.BPTREE_BRANCH && type != BlockType.BPTREE_LEAF) {
                    throw new BPTreeException("Wrong block type: " + (Object)((Object)type));
                }
                int count = BPTreeNodeMgr.decodeCount(x);
                return BPTreeNodeMgr.overlay(BPTreeNodeMgr.this.bpTree, byteBuffer, type == BlockType.BPTREE_LEAF, count);
            }
        }

        @Override
        public ByteBuffer toByteBuffer(BPTreeNode node) {
            ByteBuffer bb = node.getBackingByteBuffer();
            BlockType bType = node.isLeaf ? BlockType.BPTREE_LEAF : BlockType.BPTREE_BRANCH;
            int c = BPTreeNodeMgr.encodeCount(bType, node.getCount());
            bb.putInt(0, c);
            return bb;
        }
    }
}

