/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.index.TupleIndexBase;
import com.hp.hpl.jena.tdb.index.mem.Index;
import com.hp.hpl.jena.tdb.index.mem.Index3;
import com.hp.hpl.jena.tdb.index.mem.IterFunc;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.iterator.NullIterator;
import org.openjena.atlas.iterator.SingletonIterator;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.InternalErrorException;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleIndexMem
extends TupleIndexBase {
    private Index3<NodeId, NodeId, NodeId, Tuple<NodeId>> index = new Index3();

    public TupleIndexMem(int N, ColumnMap colMapping) {
        super(N, colMapping);
        if (N != 3) {
            throw new UnsupportedOperationException("TupleIndexMem - triples only");
        }
    }

    @Override
    protected boolean performAdd(Tuple<NodeId> tuple) {
        NodeId x1 = (NodeId)this.colMap.mapSlot(0, tuple);
        NodeId x2 = (NodeId)this.colMap.mapSlot(1, tuple);
        NodeId x3 = (NodeId)this.colMap.mapSlot(2, tuple);
        return this.index.put(x1, x2, x3, tuple);
    }

    @Override
    protected boolean performDelete(Tuple<NodeId> tuple) {
        NodeId x1 = (NodeId)this.colMap.mapSlot(0, tuple);
        NodeId x2 = (NodeId)this.colMap.mapSlot(1, tuple);
        NodeId x3 = (NodeId)this.colMap.mapSlot(2, tuple);
        return this.index.remove(x1, x2, x3);
    }

    @Override
    public Iterator<Tuple<NodeId>> all() {
        return this.index.flatten();
    }

    @Override
    protected Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> pattern) {
        NodeId x3;
        NodeId x2;
        NodeId x1 = (NodeId)this.colMap.mapSlot(0, pattern);
        if (NodeId.doesNotExist(x1)) {
            return new NullIterator();
        }
        if (this.undef(x1)) {
            x1 = null;
        }
        if (NodeId.doesNotExist(x2 = (NodeId)this.colMap.mapSlot(1, pattern))) {
            return new NullIterator();
        }
        if (this.undef(x2)) {
            x2 = null;
        }
        if (NodeId.doesNotExist(x3 = (NodeId)this.colMap.mapSlot(2, pattern))) {
            return new NullIterator();
        }
        if (this.undef(x3)) {
            x3 = null;
        }
        if (x1 == null) {
            throw new InternalErrorException("TupleIndexMem.find: no first index");
        }
        if (x2 == null) {
            Index<NodeId, Index<NodeId, Tuple<NodeId>>> idx = this.index.get(x1);
            return IterFunc.flattenII(idx);
        }
        if (x3 == null) {
            Index<NodeId, Tuple<NodeId>> idx = this.index.get(x1, x2);
            return idx.values().iterator();
        }
        Tuple<NodeId> t = this.index.get(x1, x2, x3);
        if (t == null) {
            return new NullIterator();
        }
        return new SingletonIterator(t);
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public void clear() {
        this.index = new Index3();
    }

    @Override
    public long size() {
        return this.index.size();
    }

    public void sync() {
        this.sync(true);
    }

    public void sync(boolean force) {
    }

    public void close() {
    }
}

