/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.objectfile;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.file.FileBase;
import com.hp.hpl.jena.tdb.base.file.FileException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.lib.StringAbbrev;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFileDiskDirect
implements ObjectFile {
    protected long filesize;
    protected final FileBase file;
    private ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    static DumpHandler handler = new DumpHandler(){

        public void handle(long fileIdx, String str) {
            System.out.printf("0x%08X : %s\n", fileIdx, str);
        }
    };
    public static final boolean compression = false;
    private static StringAbbrev abbreviations = new StringAbbrev();

    public ObjectFileDiskDirect(String filename) {
        this.file = new FileBase(filename);
        try {
            this.filesize = this.file.out.length();
        }
        catch (IOException ex) {
            throw new BlockException("Failed to get filesize", ex);
        }
    }

    @Override
    public long write(ByteBuffer bb) {
        try {
            int len = bb.limit() - bb.position();
            this.lengthBuffer.clear();
            this.lengthBuffer.putInt(0, len);
            long location = this.filesize;
            this.file.channel.position(location);
            int x1 = this.file.channel.write(this.lengthBuffer);
            int x2 = this.file.channel.write(bb);
            if (x2 != len) {
                throw new FileException("ObjectFile.write: Buffer length = " + len + " : actual write = " + x2);
            }
            this.filesize = this.filesize + (long)x1 + (long)x2;
            return location;
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.write", ex);
        }
    }

    @Override
    public ByteBuffer read(long loc) {
        try {
            this.file.channel.position(loc);
            this.lengthBuffer.position(0);
            int x = this.file.channel.read(this.lengthBuffer);
            if (x != 4) {
                throw new FileException("ObjectFile.read: Failed to read the length : got " + x + " bytes");
            }
            int len = this.lengthBuffer.getInt(0);
            ByteBuffer bb = ByteBuffer.allocate(len);
            x = this.file.channel.read(bb);
            bb.flip();
            if (x != len) {
                throw new FileException("ObjectFile.read: Failed to read the object (" + len + " bytes) : got " + x + " bytes");
            }
            return bb;
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.read", ex);
        }
    }

    @Override
    public long length() {
        return this.filesize;
    }

    @Override
    public Iterator<Pair<Long, ByteBuffer>> all() {
        try {
            this.file.out.seek(0L);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.all", ex);
        }
        ObjectIterator iter = new ObjectIterator(0L, this.filesize);
        return iter;
    }

    @Override
    public void close() {
        this.file.close();
    }

    public void sync() {
        this.file.sync();
    }

    @Override
    public void sync(boolean force) {
        this.file.sync(force);
    }

    public void dump() {
        this.dump(handler);
    }

    public void dump(DumpHandler handler) {
        try {
            this.file.out.seek(0L);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.all", ex);
        }
        long fileIdx = 0L;
        while (fileIdx < this.filesize) {
            ByteBuffer bb = this.read(fileIdx);
            String str = Bytes.fromByteBuffer((ByteBuffer)bb);
            handler.handle(fileIdx, str);
            fileIdx = fileIdx + (long)bb.limit() + 4L;
        }
    }

    private String compress(String str) {
        return str;
    }

    private String decompress(String x) {
        return x;
    }

    static {
        abbreviations.add("rdf", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        abbreviations.add("rdfs", "<http://www.w3.org/2000/01/rdf-schema#");
        abbreviations.add("xsd", "<http://www.w3.org/2001/XMLSchema#");
        abbreviations.add("mal", "<http://musicbrainz.org/mm-2.1/album/");
        abbreviations.add("mt", "<http://musicbrainz.org/mm-2.1/track/");
        abbreviations.add("mar", "<http://musicbrainz.org/mm-2.1/artist/");
        abbreviations.add("mtr", "<http://musicbrainz.org/mm-2.1/trmid/");
        abbreviations.add("mc", "<http://musicbrainz.org/mm-2.1/cdindex/");
        abbreviations.add("m21", "<http://musicbrainz.org/mm/mm-2.1#");
        abbreviations.add("dc", "<http://purl.org/dc/elements/1.1/");
        abbreviations.add("r", "<http://dbpedia/resource/");
        abbreviations.add("p", "<http://dbpedia/property/");
    }

    public static interface DumpHandler {
        public void handle(long var1, String var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectIterator
    implements Iterator<Pair<Long, ByteBuffer>> {
        private final long start;
        private final long finish;
        private long current;

        public ObjectIterator(long start, long finish) {
            this.start = start;
            this.finish = finish;
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.finish;
        }

        @Override
        public Pair<Long, ByteBuffer> next() {
            long x = this.current;
            ByteBuffer bb = ObjectFileDiskDirect.this.read(this.current);
            this.current = this.current + (long)bb.limit() + 4L;
            return new Pair((Object)x, (Object)bb);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

