/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.buffer;

import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.record.Record;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openjena.atlas.lib.Lib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordBufferIterator
implements Iterator<Record> {
    private RecordBuffer rBuff;
    private int nextIdx;
    private Record slot = null;
    private final Record maxRec;
    private final Record minRec;

    RecordBufferIterator(RecordBuffer rBuff) {
        this(rBuff, null, null);
    }

    RecordBufferIterator(RecordBuffer rBuff, Record minRecord, Record maxRecord) {
        this.rBuff = rBuff;
        this.nextIdx = 0;
        this.minRec = minRecord;
        if (this.minRec != null) {
            this.nextIdx = rBuff.find(this.minRec);
            if (this.nextIdx < 0) {
                this.nextIdx = Lib.decodeIndex((int)this.nextIdx);
            }
        }
        this.maxRec = maxRecord;
    }

    private void finish() {
        this.rBuff = null;
        this.nextIdx = -99;
        this.slot = null;
    }

    @Override
    public boolean hasNext() {
        if (this.slot != null) {
            return true;
        }
        if (this.nextIdx < 0) {
            return false;
        }
        if (this.nextIdx >= this.rBuff.size()) {
            this.finish();
            return false;
        }
        this.slot = this.rBuff.get(this.nextIdx);
        if (this.maxRec != null && Record.keyGE(this.slot, this.maxRec)) {
            this.finish();
            return false;
        }
        ++this.nextIdx;
        return true;
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("RecordBufferIterator");
        }
        Record r = this.slot;
        this.slot = null;
        return r;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("RecordBufferIterator.remove");
    }
}

