/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.TDBMaker;

public class TDBFactory {
    public static Model assembleModel(String assemblerFile) {
        return (Model)AssemblerUtils.build((String)assemblerFile, (Resource)VocabTDB.tGraphTDB);
    }

    public static Graph assembleGraph(String assemblerFile) {
        Model m = TDBFactory.assembleModel(assemblerFile);
        Graph g = m.getGraph();
        return g;
    }

    public static Dataset assembleDataset(String assemblerFile) {
        return (Dataset)AssemblerUtils.build((String)assemblerFile, (Resource)VocabTDB.tDatasetTDB);
    }

    public static Model createModel(Location loc) {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph(loc));
    }

    public static Model createModel(String dir) {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph(dir));
    }

    public static Model createModel() {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph());
    }

    public static Model createNamedModel(String name, String location) {
        return TDBFactory.createDataset(location).getNamedModel(name);
    }

    public static Model createNamedModel(String name, Location location) {
        return TDBFactory.createDataset(location).getNamedModel(name);
    }

    public static Dataset createDataset(String dir) {
        return TDBFactory.createDataset(new Location(dir));
    }

    public static Dataset createDataset(Location location) {
        return new DatasetImpl((DatasetGraph)TDBMaker._createDatasetGraph(location));
    }

    public static Dataset createDataset() {
        return new DatasetImpl((DatasetGraph)TDBMaker._createDatasetGraph());
    }

    public static Graph createGraph(Location loc) {
        return TDBMaker._createGraph(loc);
    }

    public static Graph createGraph(String dir) {
        Location loc = new Location(dir);
        return TDBFactory.createGraph(loc);
    }

    public static Graph createGraph() {
        return TDBMaker._createGraph();
    }

    public static Graph createNamedGraph(String name, String location) {
        return TDBFactory.createDatasetGraph(location).getGraph(Node.createURI((String)name));
    }

    public static Graph createNamedGraph(String name, Location location) {
        return TDBFactory.createDatasetGraph(location).getGraph(Node.createURI((String)name));
    }

    public static DatasetGraphTDB createDatasetGraph(String directory) {
        return TDBMaker._createDatasetGraph(new Location(directory));
    }

    public static DatasetGraphTDB createDatasetGraph(Location location) {
        return TDBMaker._createDatasetGraph(location);
    }

    public static DatasetGraphTDB createDatasetGraph() {
        return TDBMaker._createDatasetGraph();
    }
}

