/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.engine.main.OpExecutorFactory;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.lib.Metadata;
import com.hp.hpl.jena.sparql.mgt.ARQMgt;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.assembler.AssemblerTDB;
import com.hp.hpl.jena.tdb.modify.UpdateProcessorTDB;
import com.hp.hpl.jena.tdb.solver.Explain;
import com.hp.hpl.jena.tdb.solver.OpExecutorTDB;
import com.hp.hpl.jena.tdb.solver.QueryEngineTDB;
import com.hp.hpl.jena.tdb.solver.StageGeneratorDirectTDB;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.EnvTDB;
import com.hp.hpl.jena.tdb.sys.SetupTDB;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.tdb.sys.TDBMaker;
import java.util.Iterator;
import org.openjena.atlas.lib.Sync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDB {
    public static final String tdbIRI = "http://jena.hpl.hp.com/#tdb";
    private static final Logger log = LoggerFactory.getLogger(TDB.class);
    public static final String logInfoName = "com.hp.hpl.jena.tdb.info";
    public static final Logger logInfo = LoggerFactory.getLogger((String)"com.hp.hpl.jena.tdb.info");
    public static final String logLoaderName = "com.hp.hpl.jena.tdb.loader";
    public static final Logger logLoader = LoggerFactory.getLogger((String)"com.hp.hpl.jena.tdb.loader");
    public static final String logExecName = "com.hp.hpl.jena.tdb.exec";
    public static final Logger logExec = LoggerFactory.getLogger((String)"com.hp.hpl.jena.tdb.exec");
    public static final String namespace = "http://jena.hpl.hp.com/2008/tdb#";
    public static final Symbol symUnionDefaultGraph = SystemTDB.allocSymbol("unionDefaultGraph");
    public static final Symbol symLogExec = SystemTDB.allocSymbol("logExec");
    private static boolean initialized;
    private static String metadataLocation;
    private static Metadata metadata;
    public static final String PATH = "com.hp.hpl.jena.tdb";
    public static final String NAME = "TDB";
    public static final String VERSION;
    public static final String BUILD_DATE;

    @Deprecated
    public static void setExecutionLogging(boolean state) {
        if (!state) {
            TDB.getContext().unset(symLogExec);
            return;
        }
        TDB.getContext().set(symLogExec, state);
        if (!logExec.isInfoEnabled()) {
            log.warn("Attempt to enable execution logging but the logger is not logging at level info");
        }
    }

    public static void setExecutionLogging(Explain.InfoLevel infoLevel) {
        if (Explain.InfoLevel.NONE.equals((Object)infoLevel)) {
            TDB.getContext().unset(symLogExec);
            return;
        }
        TDB.getContext().set(symLogExec, (Object)infoLevel);
        if (!logExec.isInfoEnabled()) {
            log.warn("Attempt to enable execution logging but the logger is not logging at level info");
        }
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    public static void init() {
    }

    public static void closedown() {
        TDBMaker.clearDatasetCache();
    }

    public static void setOptimizerWarningFlag(boolean b) {
        SetupTDB.setOptimizerWarningFlag(b);
    }

    public static void sync(Model model) {
        TDB.sync(model.getGraph());
    }

    public static void sync(Graph graph) {
        TDB.sync(graph, true);
    }

    public static void sync(Dataset dataset) {
        DatasetGraph ds = dataset.asDatasetGraph();
        TDB.sync(ds);
    }

    public static void sync(DatasetGraph dataset) {
        if (dataset instanceof DatasetGraphTDB) {
            TDB.sync(dataset, true);
        } else {
            Iterator iter = dataset.listGraphNodes();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                Graph g = dataset.getGraph(n);
                TDB.sync(g);
            }
        }
    }

    private static void sync(Object object, boolean force) {
        if (object instanceof Sync) {
            ((Sync)object).sync(force);
        }
    }

    private static synchronized void initialization1() {
        if (initialized) {
            return;
        }
        initialized = true;
        SystemTDB.init();
        ARQ.init();
        EnvTDB.processGlobalSystemProperties();
        AssemblerUtils.init();
        AssemblerTDB.init();
        QueryEngineTDB.register();
        UpdateProcessorTDB.register();
        TDB.wireIntoExecution();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TDBMaker.syncDatasetCache();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
        if (log.isDebugEnabled()) {
            log.debug("\n" + ARQ.getContext());
        }
    }

    private static void wireIntoExecution() {
        TDB.getContext().set(ARQ.optFilterPlacement, false);
        StageGenerator orig = (StageGenerator)ARQ.getContext().get(ARQ.stageGenerator);
        StageGeneratorDirectTDB stageGenerator = new StageGeneratorDirectTDB(orig);
        StageBuilder.setGenerator((Context)ARQ.getContext(), (StageGenerator)stageGenerator);
        QC.setFactory((Context)ARQ.getContext(), (OpExecutorFactory)OpExecutorTDB.OpExecFactoryTDB);
    }

    private static void initialization2() {
        String NS = PATH;
        SystemInfo systemInfo = new SystemInfo(tdbIRI, VERSION, BUILD_DATE);
        ARQMgt.register((String)(NS + ".system:type=SystemInfo"), (Object)systemInfo);
        SystemARQ.registerSubSystem((SystemInfo)systemInfo);
    }

    static {
        TDB.initialization1();
        initialized = false;
        metadataLocation = "com/hp/hpl/jena/tdb/tdb-properties.xml";
        metadata = new Metadata(metadataLocation);
        VERSION = metadata.get("com.hp.hpl.jena.tdb.version", "DEV");
        BUILD_DATE = metadata.get("com.hp.hpl.jena.tdb.build.datetime", "unset");
        TDB.initialization2();
    }
}

