/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.DatasetGraphMakerTDB;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingTDBMaker
implements DatasetGraphMakerTDB {
    private static Logger log = LoggerFactory.getLogger(CachingTDBMaker.class);
    private DatasetGraphMakerTDB factory1;
    private Map<String, DatasetGraphTDB> cache = new HashMap<String, DatasetGraphTDB>();

    public CachingTDBMaker(DatasetGraphMakerTDB factory) {
        this.factory1 = factory;
    }

    public DatasetGraphTDB createDatasetGraph() {
        return this.factory1.createDatasetGraph();
    }

    public DatasetGraphTDB createDatasetGraph(Location location) {
        String absPath = location.getDirectoryPath();
        DatasetGraphTDB dg = this.cache.get(absPath);
        if (dg == null) {
            dg = this.factory1.createDatasetGraph(location);
            log.debug("Add to dataset cache: " + absPath);
            this.cache.put(absPath, dg);
        } else {
            log.debug("Reuse from dataset cache: " + absPath);
        }
        return dg;
    }

    public void flush() {
        this.sync();
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        for (DatasetGraphTDB dsg : this.cache.values()) {
            dsg.getLock().enterCriticalSection(false);
            try {
                dsg.sync();
            }
            finally {
                dsg.getLock().leaveCriticalSection();
            }
        }
    }

    public void releaseDatasetGraph(DatasetGraphTDB dataset) {
        Location location = dataset.getLocation();
        if (location == null) {
            return;
        }
        String absPath = location.getDirectoryPath();
        if (!this.cache.containsKey(absPath) && !absPath.equals("--mem--")) {
            log.warn("Not a cached location: " + absPath);
        }
        log.debug("Remove from dataset cache: " + absPath);
        this.cache.remove(absPath);
    }
}

