/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.engine.QueryEngineSDB;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpPrefixesUsed;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import java.io.OutputStream;
import org.openjena.atlas.io.IndentedWriter;

public class PrintSDB {
    public static String divider = "----------------";

    public static void print(Store store, Query query2, QueryEngineSDB queryEngine) {
        if (queryEngine == null) {
            queryEngine = new QueryEngineSDB(store, query2);
        }
        Op op = queryEngine.getPlan().getOp();
        System.out.println(op.toString(query2.getPrefixMapping()));
    }

    public static void print(Op op) {
        PrintSDB.print(op, null);
    }

    public static void print(Op op, PrefixMapping pmap) {
        if (pmap == null) {
            pmap = OpPrefixesUsed.used((Op)op, (PrefixMapping)ARQConstants.getGlobalPrefixMap());
        }
        System.out.print(op.toString(pmap));
    }

    public static void printSQL(Op op) {
        OpWalker.walk((Op)op, (OpVisitor)new PrintSQL());
    }

    public static void printSqlNodes(Op op) {
        OpWalker.walk((Op)op, (OpVisitor)new PrintSqlNodes());
    }

    static class PrintSQL
    extends OpVisitorBase {
        boolean first = true;
        private IndentedWriter out;

        PrintSQL(IndentedWriter out) {
            this.out = out;
        }

        PrintSQL() {
            this.out = new IndentedWriter((OutputStream)System.out);
        }

        public void visit(OpExt op) {
            if (!(op instanceof OpSQL)) {
                super.visit(op);
                return;
            }
            OpSQL opSQL = (OpSQL)op;
            if (!this.first) {
                this.out.println((Object)divider);
            }
            this.out.print((Object)opSQL.toSQL());
            this.out.ensureStartOfLine();
            this.out.flush();
            this.first = false;
        }
    }

    static class PrintSqlNodes
    extends OpVisitorBase {
        boolean first = true;
        private IndentedWriter out;

        PrintSqlNodes(IndentedWriter out) {
            this.out = out;
        }

        PrintSqlNodes() {
            this.out = new IndentedWriter((OutputStream)System.out);
        }

        public void visit(OpExt op) {
            if (!(op instanceof OpSQL)) {
                super.visit(op);
                return;
            }
            OpSQL opSQL = (OpSQL)op;
            if (!this.first) {
                this.out.println((Object)divider);
            }
            opSQL.output(this.out);
            this.out.ensureStartOfLine();
            this.out.flush();
            this.first = false;
        }
    }
}

