/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.sdb.sql.FunctionsSQL;

public class SQLUtilsStd {
    private static final String strQuoteChar = "'";
    private static final String strQuoteCharEsc = "''";
    private static final String strQuoteChar2 = "\\";
    private static final String strQuoteCharEsc2 = "\\\\";
    private static final String[] strChar = new String[]{"'", "\\"};
    private static final String[] strCharEsc = new String[]{"''", "\\\\"};
    private static String identifierQuoteChar = "\"";
    private static String identifierQuoteChar2 = "\"\"";
    private static final String SQLmark = "_";

    public String escapeStr(String s) {
        return FunctionsSQL.replace(s, strChar, strCharEsc);
    }

    public String unescapeStr(String s) {
        return FunctionsSQL.replace(s, strCharEsc, strChar);
    }

    public String quoteStr(String s) {
        s = this.escapeStr(s);
        return strQuoteChar + s + strQuoteChar;
    }

    public String unquoteStr(String s) {
        if (s.startsWith(strQuoteChar)) {
            s = s.substring(1, s.length() - 1);
        }
        s = this.unescapeStr(s);
        return s;
    }

    public String quoteIdentifier(String name) {
        if (FunctionsSQL.sqlSafeChar(name)) {
            return name;
        }
        name = name.replace(identifierQuoteChar, identifierQuoteChar2);
        return identifierQuoteChar + name + identifierQuoteChar;
    }

    public String getSQLmark() {
        return SQLmark;
    }

    public String gen(String first, String last) {
        return first + SQLmark + last;
    }

    public String gen(String first) {
        return first + SQLmark;
    }
}

