/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.expr;

import com.hp.hpl.jena.sdb.compiler.ConditionCompiler;
import com.hp.hpl.jena.sdb.compiler.SDBConstraint;
import com.hp.hpl.jena.sdb.core.ExprPattern;
import com.hp.hpl.jena.sdb.exprmatch.ActionMatch;
import com.hp.hpl.jena.sdb.exprmatch.ActionMatchString;
import com.hp.hpl.jena.sdb.exprmatch.ActionMatchVar;
import com.hp.hpl.jena.sdb.exprmatch.MapResult;
import com.hp.hpl.jena.sdb.layout2.expr.RegexSqlGen;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;

public class RegexCompiler
implements ConditionCompiler {
    private static ExprPattern regex1 = new ExprPattern("regex(?a1, ?a2)", new Var[]{Var.alloc((String)"a1"), Var.alloc((String)"a2")}, new ActionMatch[]{new ActionMatchVar(), new ActionMatchString()});
    private static ExprPattern regex1_i = new ExprPattern("regex(?a1, ?a2, 'i')", new Var[]{Var.alloc((String)"a1"), Var.alloc((String)"a2")}, new ActionMatch[]{new ActionMatchVar(), new ActionMatchString()});

    public SDBConstraint recognize(Expr expr) {
        MapResult rMap = null;
        rMap = regex1.match(expr);
        if (rMap != null) {
            Var var = rMap.get("a1").getExprVar().asVar();
            String pattern = rMap.get("a2").getConstant().getString();
            return new RegexSqlGen(expr, regex1, pattern, null, true);
        }
        rMap = regex1_i.match(expr);
        if (rMap != null) {
            Var var = ((Expr)rMap.get(Var.alloc((String)"a1"))).getExprVar().asVar();
            String pattern = ((Expr)rMap.get(Var.alloc((String)"a2"))).getConstant().getString();
            return new RegexSqlGen(expr, regex1_i, pattern, "i", true);
        }
        return null;
    }
}

