/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.Scope;
import com.hp.hpl.jena.sdb.core.ScopeBase;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeBase0;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTransform;
import com.hp.hpl.jena.sparql.core.Var;

public class SqlTable
extends SqlNodeBase0 {
    private String tableName;
    protected ScopeBase idScope = null;
    protected ScopeBase nodeScope = null;

    public SqlTable(String name) {
        this(name, name);
    }

    public SqlTable(String aliasName, String tableName) {
        this(aliasName, tableName, new ScopeBase(), new ScopeBase());
    }

    private SqlTable(String aliasName, String tableName, ScopeBase idScope, ScopeBase nodeScope) {
        super(aliasName);
        this.tableName = tableName;
        this.idScope = idScope;
        this.nodeScope = nodeScope;
    }

    public boolean isTable() {
        return true;
    }

    public SqlTable asTable() {
        return this;
    }

    public boolean usesColumn(SqlColumn c) {
        return c.getTable() == this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void visit(SqlNodeVisitor visitor) {
        visitor.visit(this);
    }

    public Scope getIdScope() {
        return this.idScope;
    }

    public Scope getNodeScope() {
        return this.nodeScope;
    }

    public void setIdColumnForVar(Var var, SqlColumn thisCol) {
        this.idScope.setColumnForVar(var, thisCol);
    }

    public void setValueColumnForVar(Var var, SqlColumn thisCol) {
        if (this.nodeScope == null) {
            this.nodeScope = new ScopeBase();
        }
        this.nodeScope.setColumnForVar(var, thisCol);
    }

    public int hashCode() {
        int h = 981;
        if (this.tableName != null) {
            h ^= this.tableName.hashCode();
        }
        if (this.getAliasName() != null) {
            h ^= this.getAliasName().hashCode() << 1;
        }
        return h;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SqlTable)) {
            return false;
        }
        SqlTable table = (SqlTable)other;
        if (!this.tableName.equals(table.tableName)) {
            return false;
        }
        if (this.getAliasName() == null && table.getAliasName() == null) {
            return true;
        }
        if (this.getAliasName() == null || table.getAliasName() == null) {
            return false;
        }
        return this.getAliasName().equals(table.getAliasName());
    }

    public SqlNode apply(SqlTransform transform) {
        return transform.transform(this);
    }

    public SqlNode copy() {
        return new SqlTable(this.tableName, this.getAliasName(), this.idScope, this.nodeScope);
    }
}

