/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprList;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeBase1;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTransform;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;

public class SqlRestrict
extends SqlNodeBase1 {
    private SqlExprList conditions = new SqlExprList();

    private static SqlNode restrict(SqlNode sqlNode, SqlExpr condition) {
        if (sqlNode.isJoin()) {
            sqlNode.asJoin().addCondition(condition);
            return sqlNode;
        }
        if (sqlNode.isRestrict()) {
            sqlNode.asRestrict().conditions.add(condition);
            return sqlNode;
        }
        return new SqlRestrict(sqlNode.getAliasName(), sqlNode, condition);
    }

    private static SqlNode restrict(SqlNode sqlNode, SqlExprList restrictions) {
        if (restrictions.size() == 0) {
            return sqlNode;
        }
        if (sqlNode.isJoin()) {
            sqlNode.asJoin().addConditions(restrictions);
            return sqlNode;
        }
        if (sqlNode.isRestrict()) {
            sqlNode.asRestrict().conditions.addAll(restrictions);
            return sqlNode;
        }
        return new SqlRestrict(sqlNode.getAliasName(), sqlNode, restrictions);
    }

    private SqlRestrict(SqlNode sqlNode, SqlExpr condition) {
        super(null, sqlNode);
        this.conditions.add(condition);
    }

    private SqlRestrict(String aliasName, SqlNode sqlNode, SqlExpr condition) {
        super(aliasName, sqlNode);
        this.conditions.add(condition);
    }

    private SqlRestrict(String aliasName, SqlNode sqlNode, SqlExprList conditions) {
        super(aliasName, sqlNode);
        this.conditions = conditions;
    }

    private SqlRestrict(SqlTable table, SqlExprList conditions) {
        super(table.getAliasName(), table);
        this.conditions = conditions;
    }

    public boolean isRestrict() {
        return true;
    }

    public SqlRestrict asRestrict() {
        return this;
    }

    public SqlExprList getConditions() {
        return this.conditions;
    }

    public void visit(SqlNodeVisitor visitor) {
        throw new SDBInternalError("SqlRestrict.visit");
    }

    public SqlNode apply(SqlTransform transform, SqlNode subNode) {
        throw new SDBInternalError("SqlRestrict.apply");
    }

    public SqlNode copy(SqlNode subNode) {
        return new SqlRestrict(this.getAliasName(), subNode, this.conditions);
    }
}

