/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.ColAlias;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeBase1;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTransform;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlProject
extends SqlNodeBase1 {
    List<ColAlias> cols = null;

    private static SqlNode project(SqlNode sqlNode) {
        return SqlProject.project(sqlNode, null);
    }

    private static SqlNode project(SqlNode sqlNode, SqlColumn col, String colOutName) {
        SqlColumn asCol = new SqlColumn(null, colOutName);
        ColAlias colAlias = new ColAlias(col, asCol);
        return SqlProject.project(sqlNode, colAlias);
    }

    public static SqlNode project(SqlNode sqlNode, ColAlias col) {
        SqlProject p = SqlProject.ensure(sqlNode);
        if (col != null) {
            SqlProject.verify(p, col);
            col.check(sqlNode.getAliasName());
            p.cols.add(col);
        }
        return p;
    }

    private static void verify(SqlProject p, ColAlias col) {
        String newColName = col.getAlias().getColumnName();
        for (ColAlias a : p.getCols()) {
            if (!a.getAlias().getColumnName().equals(newColName)) continue;
            throw new SDBInternalError("Attempt to use same alias twice");
        }
    }

    private static SqlProject ensure(SqlNode sqlNode) {
        if (sqlNode.isProject()) {
            return sqlNode.asProject();
        }
        return new SqlProject(sqlNode);
    }

    private SqlProject(SqlNode sqlNode) {
        this(sqlNode, new ArrayList<ColAlias>());
    }

    private SqlProject(SqlNode sqlNode, List<ColAlias> cols) {
        super(null, sqlNode);
        this.cols = cols;
    }

    @Override
    public boolean isProject() {
        return true;
    }

    @Override
    public SqlProject asProject() {
        return this;
    }

    @Override
    public boolean usesColumn(SqlColumn c) {
        return this.cols.contains(c);
    }

    public List<ColAlias> getCols() {
        return this.cols;
    }

    @Override
    public void visit(SqlNodeVisitor visitor) {
        throw new SDBInternalError("SqlProject.visit");
    }

    @Override
    public SqlNode apply(SqlTransform transform, SqlNode subNode) {
        throw new SDBInternalError("SqlProject.apply");
    }

    @Override
    public SqlNode copy(SqlNode subNode) {
        return new SqlProject(subNode, this.getCols());
    }
}

