/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core;

import com.hp.hpl.jena.sdb.core.Scope;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.iterator.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeRename
implements Scope {
    private static Logger log = LoggerFactory.getLogger(ScopeRename.class);
    private Scope scope;
    private Map<Var, SqlColumn> frame = new HashMap<Var, SqlColumn>();
    private Transform<ScopeEntry, ScopeEntry> converter = new Transform<ScopeEntry, ScopeEntry>(){

        public ScopeEntry convert(ScopeEntry entry) {
            entry = new ScopeEntry(entry.getVar(), entry.getColumn());
            Var var = entry.getVar();
            SqlColumn col = (SqlColumn)ScopeRename.this.frame.get(var);
            if (col == null) {
                log.warn("No alias for variable " + var);
                return entry;
            }
            ScopeEntry entry2 = new ScopeEntry(entry.getVar(), entry.getColumn());
            entry2.setStatus(entry.getStatus());
            return entry2;
        }
    };

    public ScopeRename(Scope oldScope) {
        this.scope = oldScope;
    }

    public void setAlias(Var var, SqlColumn col) {
        if (!this.scope.hasColumnForVar(var)) {
            log.warn("No underlying column for variable " + var);
        }
        this.frame.put(var, col);
    }

    @Override
    public ScopeEntry findScopeForVar(Var var) {
        this.check(var);
        if (!this.frame.containsKey(var)) {
            return null;
        }
        ScopeEntry e = new ScopeEntry(var, this.frame.get(var));
        e.setStatus(this.scope.findScopeForVar(var).getStatus());
        return e;
    }

    @Override
    public Set<ScopeEntry> findScopes() {
        HashSet<ScopeEntry> x = new HashSet<ScopeEntry>();
        for (Var v : this.frame.keySet()) {
            ScopeEntry e = this.findScopeForVar(v);
            x.add(e);
        }
        return x;
    }

    @Override
    public boolean isEmpty() {
        return this.frame.isEmpty();
    }

    @Override
    public Set<Var> getVars() {
        return this.frame.keySet();
    }

    @Override
    public boolean hasColumnForVar(Var var) {
        this.check(var);
        return this.frame.containsKey(var);
    }

    private void check(Var var) {
        boolean sub = this.scope.hasColumnForVar(var);
        boolean res = this.frame.containsKey(var);
        if (sub && !res) {
            log.warn("Corruption: in subscope but not in aliases: " + var);
        }
        if (!sub && res) {
            log.warn("Corruption: not in subscope but in aliases: " + var);
        }
    }

    public String toString() {
        return this.frame + " " + this.scope;
    }
}

