/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.compiler.PatternTable;
import com.hp.hpl.jena.sdb.compiler.QuadBlock;
import com.hp.hpl.jena.sdb.compiler.QuadBlockCompiler;
import com.hp.hpl.jena.sdb.compiler.SlotCompiler;
import com.hp.hpl.jena.sdb.compiler.SqlBuilder;
import com.hp.hpl.jena.sdb.compiler.SqlStage;
import com.hp.hpl.jena.sdb.compiler.SqlStageBasicQuad;
import com.hp.hpl.jena.sdb.compiler.SqlStageList;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sparql.core.Quad;

public class QuadBlockCompilerMain
implements QuadBlockCompiler {
    SDBRequest request;
    SlotCompiler slotCompiler;
    public static PatternTable patternTable = null;

    public QuadBlockCompilerMain(SDBRequest request, SlotCompiler slotCompiler) {
        this.request = request;
        this.slotCompiler = slotCompiler;
    }

    public SlotCompiler getSlotCompiler() {
        return this.slotCompiler;
    }

    public final SqlNode compile(QuadBlock quads) {
        SqlNode sqlNode = this.slotCompiler.start(quads);
        quads = new QuadBlock(quads);
        SqlStageList sList = new SqlStageList();
        int i = 0;
        while (i < quads.size()) {
            SqlStage stage;
            Quad q = (Quad)quads.get(i);
            if (patternTable != null && patternTable.trigger(q) && (stage = patternTable.process(i, quads)) != null) {
                if (quads.get(i) == q) {
                    throw new SDBInternalError("Pattern table returned a stage but did not remove the first quad");
                }
                sList.add(stage);
                continue;
            }
            sList.add(new SqlStageBasicQuad(q));
            ++i;
        }
        SqlNode sqlStages = sList.build(this.request, this.slotCompiler);
        sqlNode = SqlBuilder.innerJoin(this.request, sqlNode, sqlStages);
        sqlNode = this.slotCompiler.finish(sqlNode, quads);
        boolean needDistinct = false;
        if (quads.getGraphNode().equals((Object)Quad.unionGraph)) {
            needDistinct = true;
        } else if (Quad.isQuadDefaultGraphGenerated((Node)quads.getGraphNode()) && this.request.getContext().isTrue(SDB.unionDefaultGraph)) {
            needDistinct = true;
        }
        if (needDistinct) {
            String renameName = this.request.genId("A");
            sqlNode = SqlBuilder.view(this.request, sqlNode);
            sqlNode = SqlBuilder.distinct(this.request, sqlNode);
        }
        return sqlNode;
    }
}

