/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBConnectionHolder;
import com.hp.hpl.jena.sdb.store.TableDesc;
import com.hp.hpl.jena.sdb.store.TupleLoader;

public abstract class TupleLoaderBase
extends SDBConnectionHolder
implements TupleLoader {
    boolean active = false;
    private int tableWidth;
    private TableDesc tableDesc;

    protected TupleLoaderBase(SDBConnection connection, TableDesc tableDesc) {
        this(connection);
        this.setTableDesc(tableDesc);
    }

    protected TupleLoaderBase(SDBConnection connection) {
        super(connection);
    }

    public String getTableName() {
        return this.tableDesc.getTableName();
    }

    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(TableDesc tDesc) {
        this.tableDesc = tDesc;
        this.tableWidth = this.tableDesc.getColNames().size();
    }

    protected int getTableWidth() {
        return this.tableWidth;
    }

    public void start() {
        if (this.active) {
            throw new SDBException("Bulk loader already active");
        }
        this.active = true;
    }

    public void finish() {
        this.active = false;
    }

    public void close() {
        this.finish();
    }
}

