/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.layout1.StoreSimpleDB2;
import com.hp.hpl.jena.sdb.layout1.StoreSimpleDerby;
import com.hp.hpl.jena.sdb.layout1.StoreSimpleH2;
import com.hp.hpl.jena.sdb.layout1.StoreSimpleHSQL;
import com.hp.hpl.jena.sdb.layout1.StoreSimpleMySQL;
import com.hp.hpl.jena.sdb.layout1.StoreSimpleOracle;
import com.hp.hpl.jena.sdb.layout1.StoreSimplePGSQL;
import com.hp.hpl.jena.sdb.layout1.StoreSimpleSQLServer;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashDB2;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashDerby;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashH2;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashHSQL;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashMySQL;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashOracle;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashPGSQL;
import com.hp.hpl.jena.sdb.layout2.hash.StoreTriplesNodesHashSQLServer;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexDB2;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexDerby;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexH2;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexHSQL;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexMySQL;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexOracle;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexPGSQL;
import com.hp.hpl.jena.sdb.layout2.index.StoreTriplesNodesIndexSQLServer;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBConnectionDesc;
import com.hp.hpl.jena.sdb.sql.SDBConnectionFactory;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sdb.store.StoreMaker;
import com.hp.hpl.jena.sdb.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreFactory {
    private static Logger log = LoggerFactory.getLogger(StoreFactory.class);
    private static Registry registry;

    public static Store create(String filename) {
        return StoreFactory.create(StoreDesc.read(filename), null);
    }

    public static Store create(SDBConnection sdb, LayoutType layout, DatabaseType dbType) {
        StoreDesc desc = new StoreDesc(layout, dbType);
        return StoreFactory.create(desc, sdb);
    }

    public static Store create(LayoutType layout, DatabaseType dbType) {
        StoreDesc desc = new StoreDesc(layout, dbType);
        return StoreFactory.create(desc, null);
    }

    public static Store create(StoreDesc desc) {
        return StoreFactory.create(desc, null);
    }

    public static Store create(StoreDesc desc, SDBConnection sdb) {
        Store store = StoreFactory._create(sdb, desc);
        return store;
    }

    private static Store _create(SDBConnection sdb, StoreDesc desc) {
        if (sdb == null && desc.connDesc == null) {
            desc.connDesc = SDBConnectionDesc.none();
        }
        if (sdb == null && desc.connDesc.getType() == null && desc.getDbType() != null) {
            desc.connDesc.setType(desc.getDbType().getName());
        }
        if (sdb == null && desc.connDesc != null) {
            sdb = SDBConnectionFactory.create(desc.connDesc);
        }
        DatabaseType dbType = desc.getDbType();
        LayoutType layoutType = desc.getLayout();
        return StoreFactory._create(desc, sdb, dbType, layoutType);
    }

    private static Store _create(StoreDesc desc, SDBConnection sdb, DatabaseType dbType, LayoutType layoutType) {
        StoreMaker f = (StoreMaker)registry.get(dbType, layoutType);
        if (f == null) {
            log.warn(String.format("No factory for (%s, %s)", dbType.getName(), layoutType.getName()));
            return null;
        }
        return f.create(sdb, desc);
    }

    public static void register(DatabaseType dbType, LayoutType layoutType, StoreMaker factory) {
        registry.put(dbType, layoutType, factory);
    }

    private static void setRegistry() {
        StoreFactory.register(DatabaseType.Derby, LayoutType.LayoutTripleNodesHash, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesHashDerby(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.HSQLDB, LayoutType.LayoutTripleNodesHash, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesHashHSQL(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.H2, LayoutType.LayoutTripleNodesHash, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesHashH2(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.MySQL, LayoutType.LayoutTripleNodesHash, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesHashMySQL(conn, desc, desc.engineType);
            }
        });
        StoreFactory.register(DatabaseType.PostgreSQL, LayoutType.LayoutTripleNodesHash, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesHashPGSQL(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.SQLServer, LayoutType.LayoutTripleNodesHash, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesHashSQLServer(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.Oracle, LayoutType.LayoutTripleNodesHash, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesHashOracle(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.DB2, LayoutType.LayoutTripleNodesHash, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesHashDB2(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.Derby, LayoutType.LayoutTripleNodesIndex, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesIndexDerby(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.HSQLDB, LayoutType.LayoutTripleNodesIndex, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesIndexHSQL(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.H2, LayoutType.LayoutTripleNodesIndex, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesIndexH2(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.MySQL, LayoutType.LayoutTripleNodesIndex, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesIndexMySQL(conn, desc, desc.engineType);
            }
        });
        StoreFactory.register(DatabaseType.PostgreSQL, LayoutType.LayoutTripleNodesIndex, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesIndexPGSQL(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.SQLServer, LayoutType.LayoutTripleNodesIndex, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesIndexSQLServer(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.Oracle, LayoutType.LayoutTripleNodesIndex, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesIndexOracle(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.DB2, LayoutType.LayoutTripleNodesIndex, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreTriplesNodesIndexDB2(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.Derby, LayoutType.LayoutSimple, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreSimpleDerby(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.HSQLDB, LayoutType.LayoutSimple, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreSimpleHSQL(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.H2, LayoutType.LayoutSimple, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreSimpleH2(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.MySQL, LayoutType.LayoutSimple, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreSimpleMySQL(conn, desc, desc.engineType);
            }
        });
        StoreFactory.register(DatabaseType.PostgreSQL, LayoutType.LayoutSimple, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreSimplePGSQL(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.SQLServer, LayoutType.LayoutSimple, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreSimpleSQLServer(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.Oracle, LayoutType.LayoutSimple, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreSimpleOracle(conn, desc);
            }
        });
        StoreFactory.register(DatabaseType.DB2, LayoutType.LayoutSimple, new StoreMaker(){

            public Store create(SDBConnection conn, StoreDesc desc) {
                return new StoreSimpleDB2(conn, desc);
            }
        });
    }

    private static void checkRegistry() {
        DatabaseType[] dbTypes = new DatabaseType[]{DatabaseType.Derby, DatabaseType.HSQLDB, DatabaseType.H2, DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.SQLServer, DatabaseType.Oracle};
        LayoutType[] layoutTypes = new LayoutType[]{LayoutType.LayoutTripleNodesHash, LayoutType.LayoutTripleNodesIndex, LayoutType.LayoutSimple};
        HashSet<StoreMaker> seen = new HashSet<StoreMaker>();
        for (DatabaseType k1 : dbTypes) {
            for (LayoutType k2 : layoutTypes) {
                StoreMaker x;
                if (!registry.containsKey(k1, k2)) {
                    log.warn(String.format("Missing store maker: (%s, %s)", k1.getName(), k2.getName()));
                }
                if (seen.contains(x = (StoreMaker)registry.get(k1, k2))) {
                    log.warn(String.format("Duplicate store maker: (%s, %s)", k1.getName(), k2.getName()));
                }
                seen.add(x);
            }
        }
    }

    static {
        SDB.init();
        registry = new Registry();
        StoreFactory.setRegistry();
        StoreFactory.checkRegistry();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapK2<K1, K2, V> {
        private Map<Pair<K1, K2>, V> map = null;

        public MapK2() {
            this.map = new HashMap<Pair<K1, K2>, V>();
        }

        public MapK2(Map<Pair<K1, K2>, V> map) {
            this.map = map;
        }

        public V get(K1 key1, K2 key2) {
            return this.map.get(new Pair<K1, K2>(key1, key2));
        }

        public void put(K1 key1, K2 key2, V value) {
            this.map.put(new Pair<K1, K2>(key1, key2), value);
        }

        public boolean containsKey(K1 key1, K2 key2) {
            return this.map.containsKey(new Pair<K1, K2>(key1, key2));
        }

        public boolean containsValue(V value) {
            return this.map.containsValue(value);
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public void clear() {
            this.map.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Registry
    extends MapK2<DatabaseType, LayoutType, StoreMaker> {
        private Registry() {
        }
    }
}

