/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.shared.SymbolRegistry;
import com.hp.hpl.jena.sparql.util.Named;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutType
extends Symbol
implements Named {
    public static final LayoutType LayoutTripleNodesHash = new LayoutType("layout2/hash");
    public static final LayoutType LayoutTripleNodesIndex = new LayoutType("layout2/index");
    public static final LayoutType LayoutSimple = new LayoutType("layout1");
    public static final LayoutType LayoutRDB = new LayoutType("layoutRDB");
    static SymbolRegistry<LayoutType> registry = new SymbolRegistry();

    public static LayoutType fetch(String layoutTypeName) {
        if (layoutTypeName == null) {
            throw new IllegalArgumentException("LayoutType.convert: null not allowed");
        }
        LayoutType t = registry.lookup(layoutTypeName);
        if (t != null) {
            return t;
        }
        LoggerFactory.getLogger(LayoutType.class).warn("Can't turn '" + layoutTypeName + "' into a layout type");
        throw new SDBException("Can't turn '" + layoutTypeName + "' into a layout type");
    }

    static void init() {
        LayoutType.register(LayoutTripleNodesHash);
        LayoutType.registerName("layout2", LayoutTripleNodesHash);
        LayoutType.register(LayoutTripleNodesIndex);
        LayoutType.register(LayoutSimple);
        LayoutType.register(LayoutRDB);
    }

    public static List<String> allNames() {
        return registry.allNames();
    }

    public static List<LayoutType> allTypes() {
        return registry.allSymbols();
    }

    public static void register(String name) {
        if (name == null) {
            throw new IllegalArgumentException("LayoutType.register(String): null not allowed");
        }
        LayoutType.register(new LayoutType(name));
    }

    public static void register(LayoutType layoutType) {
        if (layoutType == null) {
            throw new IllegalArgumentException("LayoutType.register(LayoutType): null not allowed");
        }
        registry.register(layoutType);
    }

    public static void registerName(String layoutName, LayoutType layoutType) {
        if (layoutType == null) {
            throw new IllegalArgumentException("LayoutType.registerName: null not allowed");
        }
        registry.register(layoutName, layoutType);
    }

    private LayoutType(String layoutName) {
        super(layoutName);
    }

    public String getName() {
        return super.getSymbol();
    }

    static {
        LayoutType.init();
    }
}

