/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.script;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.assembler.CommandAssemblerException;
import com.hp.hpl.jena.sdb.script.CmdDesc;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.vocabulary.RDF;

public class CmdDescAssembler
extends AssemblerBase
implements Assembler {
    public Object open(Assembler a, Resource root, Mode mode) {
        CmdDesc cd = new CmdDesc();
        String main = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pMain);
        if (main == null) {
            main = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pClassname);
        }
        cd.setCmd(main);
        Resource x = GraphUtils.getResourceValue((Resource)root, (Property)AssemblerVocab.pArgs);
        if (x != null) {
            while (!x.equals(RDF.nil)) {
                RDFNode e = x.getRequiredProperty(RDF.first).getObject();
                x = x.getRequiredProperty(RDF.rest).getResource();
                if (e.isLiteral()) {
                    cd.addPosn(((Literal)e).getString());
                    continue;
                }
                Resource entry = (Resource)e;
                String name = GraphUtils.getStringValue((Resource)entry, (Property)AssemblerVocab.pArgName);
                String value = GraphUtils.getStringValue((Resource)entry, (Property)AssemblerVocab.pArgValue);
                if (value == null) {
                    throw new CommandAssemblerException(entry, "Strange entry: " + entry);
                }
                if (name != null) {
                    cd.addNamedArg(name, value);
                    continue;
                }
                cd.addPosn(value);
            }
        }
        return cd;
    }
}

