/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.hash.FmtLayout2HashH2;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;

public class FmtLayout2IndexH2
extends FmtLayout2HashH2 {
    public FmtLayout2IndexH2(SDBConnection connection) {
        super(connection);
    }

    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s integer NOT NULL,", "    p integer NOT NULL,", "    o integer NOT NULL,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g integer NOT NULL,", "    s integer NOT NULL,", "    p integer NOT NULL,", "    o integer NOT NULL,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   id SERIAL,", "   hash BIGINT NOT NULL,", "   lex CLOB NOT NULL,", "   lang varchar NOT NULL default '',", "   datatype varchar(200) NOT NULL default '',", "   type integer NOT NULL default '0',", "   PRIMARY KEY (id)", ")"));
            this.connection().exec("CREATE UNIQUE INDEX Hash ON " + TableDescNodes.name() + " (hash)");
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescNodes.name() + "'", ex);
        }
    }
}

