/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sparql.util.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ValueType implements Named
{
    BNODE{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 1;
        }

        public String getName() {
            return "BNode";
        }
    }
    ,
    URI{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 2;
        }

        public String getName() {
            return "URI";
        }
    }
    ,
    STRING{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 3;
        }

        public String getName() {
            return "String";
        }
    }
    ,
    XSDSTRING{

        public XSDDatatype getDatatype() {
            return XSDDatatype.XSDstring;
        }

        public int getTypeId() {
            return 4;
        }

        public String getName() {
            return "XSD String";
        }
    }
    ,
    INTEGER{

        public XSDDatatype getDatatype() {
            return XSDDatatype.XSDinteger;
        }

        public int getTypeId() {
            return 5;
        }

        public String getName() {
            return "Integer";
        }
    }
    ,
    DOUBLE{

        public XSDDatatype getDatatype() {
            return XSDDatatype.XSDdouble;
        }

        public int getTypeId() {
            return 6;
        }

        public String getName() {
            return "Double";
        }
    }
    ,
    DATETIME{

        public XSDDatatype getDatatype() {
            return XSDDatatype.XSDdateTime;
        }

        public int getTypeId() {
            return 7;
        }

        public String getName() {
            return "Datetime";
        }
    }
    ,
    VAR{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 8;
        }

        public String getName() {
            return "var";
        }
    }
    ,
    OTHER{

        public XSDDatatype getDatatype() {
            return null;
        }

        public int getTypeId() {
            return 50;
        }

        public String getName() {
            return "Other";
        }
    };


    public abstract int getTypeId();

    public abstract XSDDatatype getDatatype();

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public static ValueType lookup(Node n) {
        if (n.isURI()) {
            return URI;
        }
        if (n.isBlank()) {
            return BNODE;
        }
        if (n.isLiteral()) {
            if (n.getLiteralDatatypeURI() == null) {
                return STRING;
            }
            if (n.getLiteralDatatype() == XSDDatatype.XSDstring) {
                return XSDSTRING;
            }
            if (n.getLiteralDatatype() == XSDDatatype.XSDinteger) {
                return INTEGER;
            }
            if (n.getLiteralDatatype() == XSDDatatype.XSDdouble) {
                return DOUBLE;
            }
            if (n.getLiteralDatatype() == XSDDatatype.XSDdateTime) {
                return DATETIME;
            }
        }
        return OTHER;
    }

    public static ValueType lookup(int type) {
        if (type == BNODE.getTypeId()) {
            return BNODE;
        }
        if (type == URI.getTypeId()) {
            return URI;
        }
        if (type == STRING.getTypeId()) {
            return STRING;
        }
        if (type == XSDSTRING.getTypeId()) {
            return XSDSTRING;
        }
        if (type == INTEGER.getTypeId()) {
            return INTEGER;
        }
        if (type == DOUBLE.getTypeId()) {
            return DOUBLE;
        }
        if (type == DATETIME.getTypeId()) {
            return DATETIME;
        }
        if (type == VAR.getTypeId()) {
            return VAR;
        }
        if (type == OTHER.getTypeId()) {
            return OTHER;
        }
        throw new SDBException("Unknown type (" + type + ")");
    }
}

