/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sdb.compiler.SqlBuilder;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.Scope;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_Equal;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.ValueType;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sdb.store.SQLBridgeBase;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLBridge2
extends SQLBridgeBase {
    private static Logger log = LoggerFactory.getLogger(SQLBridge2.class);
    private static final String NodeBase = "R";

    public SQLBridge2(SDBRequest request, SqlNode sqlNode, Collection<Var> projectVars) {
        super(request, sqlNode, projectVars);
    }

    @Override
    protected void buildValues() {
        SqlNode sqlNode = this.getSqlNode();
        for (Var v : this.getProject()) {
            sqlNode = this.insertValueGetter(this.request, sqlNode, v);
        }
        this.setSqlNode(sqlNode);
    }

    @Override
    protected void buildProject() {
        for (Var v : this.getProject()) {
            ScopeEntry e;
            if (!v.isNamedVar() || (e = this.getSqlNode().getNodeScope().findScopeForVar(v)) == null) continue;
            SqlColumn vCol = e.getColumn();
            SqlTable table = vCol.getTable();
            String sqlVarName = this.allocSqlName(v);
            String vLex = SQLUtils.gen(sqlVarName, "lex");
            SqlColumn cLex = this.getLexSqlColumn(table);
            String vLexNChar = SQLUtils.gen(sqlVarName, "lexNChar");
            SqlColumn cLexNChar = this.getLexNCharSqlColumn(table);
            String vDatatype = SQLUtils.gen(sqlVarName, "datatype");
            SqlColumn cDatatype = new SqlColumn(table, "datatype");
            String vLang = SQLUtils.gen(sqlVarName, "lang");
            SqlColumn cLang = new SqlColumn(table, "lang");
            String vType = SQLUtils.gen(sqlVarName, "type");
            SqlColumn cType = new SqlColumn(table, "type");
            this.addProject(cLex, vLex);
            if (cLexNChar != null) {
                this.addProject(cLexNChar, vLexNChar);
            }
            this.addProject(cDatatype, vDatatype);
            this.addProject(cLang, vLang);
            this.addProject(cType, vType);
            this.addAnnotation(sqlVarName + "=" + v.toString());
        }
        this.setAnnotation();
    }

    protected SqlColumn getLexSqlColumn(SqlTable table) {
        return new SqlColumn(table, "lex");
    }

    protected SqlColumn getLexNCharSqlColumn(SqlTable table) {
        return null;
    }

    private SqlNode insertValueGetter(SDBRequest request, SqlNode sqlNode, Var var) {
        ScopeEntry e1 = sqlNode.getIdScope().findScopeForVar(var);
        if (e1 == null) {
            Scope scope = sqlNode.getIdScope();
            return sqlNode;
        }
        ScopeEntry e2 = sqlNode.getNodeScope().findScopeForVar(var);
        if (e2 != null) {
            return sqlNode;
        }
        SqlColumn c1 = e1.getColumn();
        TableDescNodes nodeTableDesc = request.getStore().getNodeTableDesc();
        String tableAlias = request.genId(NodeBase);
        SqlTable nTable = new SqlTable(tableAlias, nodeTableDesc.getTableName());
        String nodeKeyColName = nodeTableDesc.getNodeRefColName();
        SqlColumn c2 = new SqlColumn(nTable, nodeKeyColName);
        nTable.setValueColumnForVar(var, c2);
        nTable.addNote("Var: " + var);
        S_Equal cond = new S_Equal(c1, c2);
        SqlNode n = SqlBuilder.leftJoin(request, sqlNode, nTable, cond);
        return n;
    }

    @Override
    protected Binding assembleBinding(ResultSetJDBC rsHolder, Binding parent) {
        BindingMap b = new BindingMap(parent);
        ResultSet rs = rsHolder.get();
        for (Var v : super.getProject()) {
            String codename;
            if (!v.isNamedVar() || (codename = super.getSqlName(v)) == null) continue;
            try {
                int type = rs.getInt(SQLUtils.gen(codename, "type"));
                if (rs.wasNull()) continue;
                String lexColName = SQLUtils.gen(codename, "lex");
                String lex = this.getLexFromResultSet(rs, codename);
                if (lex == null) {
                    lex = "";
                }
                String datatype = rs.getString(SQLUtils.gen(codename, "datatype"));
                String lang = rs.getString(SQLUtils.gen(codename, "lang"));
                ValueType vType = ValueType.lookup(type);
                Node r = SQLBridge2.makeNode(lex, datatype, lang, vType);
                b.add(v, r);
            }
            catch (SQLException ex) {}
        }
        return b;
    }

    protected String getLexFromResultSet(ResultSet rs, String codename) throws SQLException {
        String lex = rs.getString(SQLUtils.gen(codename, "lex"));
        if (lex == null) {
            lex = "";
        }
        return lex;
    }

    private static Node makeNode(String lex, String datatype, String lang, ValueType vType) {
        switch (vType) {
            case BNODE: {
                return Node.createAnon((AnonId)new AnonId(lex));
            }
            case URI: {
                return Node.createURI((String)lex);
            }
            case STRING: {
                return Node.createLiteral((String)lex, (String)lang, (boolean)false);
            }
            case XSDSTRING: {
                return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDstring);
            }
            case INTEGER: {
                return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDinteger);
            }
            case DOUBLE: {
                return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdouble);
            }
            case DATETIME: {
                return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdateTime);
            }
            case OTHER: {
                RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(datatype);
                return Node.createLiteral((String)lex, null, (RDFDatatype)dt);
            }
        }
        log.warn("Unrecognized: (" + lex + ", " + lang + ", " + (Object)((Object)vType) + ")");
        return Node.createLiteral((String)"UNRECOGNIZED");
    }
}

