/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.exprmatch;

import com.hp.hpl.jena.sdb.exprmatch.ActionMatch;
import com.hp.hpl.jena.sdb.exprmatch.ActionMatchBind;
import com.hp.hpl.jena.sdb.exprmatch.FunctionAction;
import com.hp.hpl.jena.sdb.exprmatch.MapAction;
import com.hp.hpl.jena.sdb.exprmatch.MapCallout;
import com.hp.hpl.jena.sdb.exprmatch.MapResult;
import com.hp.hpl.jena.sdb.exprmatch.NoExprMatch;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.ExprVisitorFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.List;

public class ExprMatcher {
    public static MapResult match(Expr expression, Expr pattern, MapAction mapAction, MapCallout mapCallout, MapResult mapResult) {
        MatchVisitor m = new MatchVisitor(expression, mapAction, mapCallout, mapResult);
        try {
            pattern.visit((ExprVisitor)m);
        }
        catch (NoExprMatch ex) {
            return null;
        }
        return mapResult;
    }

    public static MapResult match(Expr expression, Expr pattern, MapAction mapAction, MapCallout mapCallout) {
        return ExprMatcher.match(expression, pattern, mapAction, mapCallout, new MapResult());
    }

    public static MapResult match(Expr expression, Expr pattern, MapAction mapAction) {
        return ExprMatcher.match(expression, pattern, mapAction, null, new MapResult());
    }

    public static MapResult match(String expression, String pattern, MapAction mapAction) {
        return ExprMatcher.match(ExprUtils.parse((String)expression), ExprUtils.parse((String)pattern), mapAction);
    }

    static class MatchVisitor
    extends ExprVisitorFunction
    implements ExprVisitor {
        private Expr target;
        private MapAction aMap;
        private MapResult rMap;
        private MapCallout cMap;
        static ActionMatch defaultAction = new ActionMatchBind();

        MatchVisitor(Expr target, MapAction aMap, MapCallout cMap, MapResult rMap) {
            this.aMap = aMap;
            this.rMap = rMap;
            this.cMap = cMap;
            this.target = target;
        }

        public void startVisit() {
        }

        public void visitExprFunction(ExprFunction patExpr) {
            String uri = patExpr.getFunctionIRI();
            if (uri != null && this.cMap != null && this.cMap.containsKey(uri)) {
                List args = patExpr.getArgs();
                if (!((FunctionAction)this.cMap.get(uri)).match(uri, args, this.rMap)) {
                    throw new NoExprMatch("Function callout rejected match");
                }
                return;
            }
            if (!this.target.isFunction()) {
                throw new NoExprMatch("Not an ExprFunction: " + this.target);
            }
            ExprFunction funcTarget = this.target.getFunction();
            if (!patExpr.getFunctionSymbol().equals((Object)funcTarget.getFunctionSymbol())) {
                throw new NoExprMatch("Different function symbols: " + patExpr.getFunctionSymbol().getSymbol() + " // " + funcTarget.getFunctionSymbol().getSymbol());
            }
            if (patExpr.numArgs() != funcTarget.numArgs()) {
                throw new NoExprMatch("Different arity: " + patExpr.numArgs() + "/" + funcTarget.numArgs());
            }
            if (!(patExpr.getFunctionIRI() == null && funcTarget.getFunctionIRI() == null || patExpr.getFunctionIRI().equals(funcTarget.getFunctionIRI()))) {
                throw new NoExprMatch("Different functions: " + patExpr.getFunctionIRI() + " " + funcTarget.getFunctionIRI());
            }
            for (int i = 1; i <= funcTarget.numArgs(); ++i) {
                Expr p = patExpr.getArg(i);
                Expr e = funcTarget.getArg(i);
                MatchVisitor m = new MatchVisitor(e, this.aMap, this.cMap, this.rMap);
                p.visit((ExprVisitor)m);
            }
        }

        public void visit(NodeValue nv) {
            if (!this.target.isConstant()) {
                throw new NoExprMatch("Not a NodeValue");
            }
            if (!nv.equals((Object)this.target.getConstant())) {
                throw new NoExprMatch("Different value: " + nv + " & " + this.target.getConstant());
            }
        }

        public void visit(ExprVar patternVar) {
            Var vn = patternVar.asVar();
            ActionMatch a = (ActionMatch)this.aMap.get(vn);
            if (a == null) {
                a = defaultAction;
            }
            if (a.match(vn, this.target, this.rMap)) {
                return;
            }
            throw new NoExprMatch("Action for " + patternVar + "+failed");
        }

        public void visit(ExprFunctionOp funcOp) {
            throw new NoExprMatch("ExprFunctionOp");
        }

        public void visit(ExprAggregator eAgg) {
            throw new NoExprMatch("ExprAggregate");
        }

        public void finishVisit() {
        }
    }
}

