/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.Scope;
import com.hp.hpl.jena.sdb.core.ScopeBase;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprList;
import com.hp.hpl.jena.sdb.core.sqlnode.ColAlias;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeBase1;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTransform;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSelectBlock
extends SqlNodeBase1 {
    private List<ColAlias> cols = new ArrayList<ColAlias>();
    private SqlExprList exprs = new SqlExprList();
    private static final int NOT_SET = -9;
    private long start = -9L;
    private long length = -9L;
    private boolean distinct = false;
    private SqlTable vTable;
    private Scope idScope = null;
    private Scope nodeScope = null;

    public static SqlNode distinct(SDBRequest request, SqlNode sqlNode) {
        SqlSelectBlock block = SqlSelectBlock.blockWithView(request, sqlNode);
        block.setDistinct(true);
        return block;
    }

    public static SqlNode project(SDBRequest request, SqlNode sqlNode) {
        return SqlSelectBlock.project(request, sqlNode, (ColAlias)null);
    }

    public static SqlNode project(SDBRequest request, SqlNode sqlNode, Collection<ColAlias> cols) {
        SqlSelectBlock block = SqlSelectBlock.blockNoView(request, sqlNode);
        if (block.idScope != null || block.nodeScope != null) {
            System.err.println("SqlSelectBlock.project : already a view");
        }
        if (cols != null) {
            block.addAll(cols);
        }
        return block;
    }

    public static SqlNode project(SDBRequest request, SqlNode sqlNode, ColAlias col) {
        SqlSelectBlock block = SqlSelectBlock.blockNoView(request, sqlNode);
        if (col != null) {
            block.add(col);
        }
        return block;
    }

    public static SqlNode slice(SDBRequest request, SqlNode sqlNode, long start, long length) {
        SqlSelectBlock block = SqlSelectBlock.blockWithView(request, sqlNode);
        if (start >= 0L) {
            if (block.getStart() > 0L) {
                start += block.getStart();
            }
            block.setStart(start);
        }
        if (length >= 0L) {
            if (block.getLength() >= 0L) {
                length = Math.min(length, block.getLength());
            }
            block.setLength(length);
        }
        return block;
    }

    public static SqlNode view(SDBRequest request, SqlNode sqlNode) {
        SqlSelectBlock block = SqlSelectBlock.blockWithView(request, sqlNode);
        return block;
    }

    public static SqlNode restrict(SDBRequest request, SqlNode sqlNode, SqlExprList exprs) {
        if (exprs.size() == 0) {
            return sqlNode;
        }
        SqlSelectBlock block = sqlNode.isTable() ? SqlSelectBlock.blockPlain(request, sqlNode) : SqlSelectBlock.blockWithView(request, sqlNode);
        block.getConditions().addAll(exprs);
        return block;
    }

    public static SqlNode restrict(SDBRequest request, SqlNode sqlNode, SqlExpr expr) {
        SqlSelectBlock block = sqlNode.isTable() ? SqlSelectBlock.blockPlain(request, sqlNode) : SqlSelectBlock.blockWithView(request, sqlNode);
        block.getConditions().add(expr);
        return block;
    }

    private SqlSelectBlock(String aliasName, SqlNode sqlNode) {
        super(aliasName, sqlNode);
        if (aliasName != null) {
            this.vTable = new SqlTable(aliasName);
        }
    }

    @Override
    public boolean isSelectBlock() {
        return true;
    }

    @Override
    public SqlSelectBlock asSelectBlock() {
        return this;
    }

    public void setBlockAlias(String alias) {
        this.aliasName = alias;
    }

    public List<ColAlias> getCols() {
        return this.cols;
    }

    public void add(ColAlias c) {
        this._add(c);
    }

    public void addAll(Collection<ColAlias> vc) {
        for (ColAlias c : vc) {
            this._add(c);
        }
    }

    private void _add(ColAlias c) {
        SqlColumn col = c.getColumn();
        SqlColumn aliasCol = c.getAlias();
        c.check(this.getAliasName());
        this.cols.add(c);
    }

    public SqlNode clearView() {
        this.idScope = null;
        this.nodeScope = null;
        this.cols.clear();
        if (!(this.distinct || this.hasConditions() || this.hasSlice())) {
            return this.getSubNode();
        }
        return this;
    }

    public SqlExprList getConditions() {
        return this.exprs;
    }

    public boolean hasSlice() {
        return this.start != -9L || this.length != -9L;
    }

    public boolean hasConditions() {
        return this.exprs.size() > 0;
    }

    public long getStart() {
        return this.start;
    }

    private void setStart(long start) {
        this.start = start;
    }

    public long getLength() {
        return this.length;
    }

    private void setLength(long length) {
        this.length = length;
    }

    @Override
    public Scope getIdScope() {
        return this.idScope != null ? this.idScope : super.getIdScope();
    }

    @Override
    public Scope getNodeScope() {
        return this.nodeScope != null ? this.nodeScope : super.getNodeScope();
    }

    @Override
    public SqlNode apply(SqlTransform transform, SqlNode newSubNode) {
        return transform.transform(this, newSubNode);
    }

    @Override
    public SqlNode copy(SqlNode subNode) {
        return new SqlSelectBlock(this.getAliasName(), subNode);
    }

    @Override
    public void visit(SqlNodeVisitor visitor) {
        visitor.visit(this);
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    private void setDistinct(boolean isDistinct) {
        this.distinct = isDistinct;
    }

    private static SqlSelectBlock blockWithView(SDBRequest request, SqlNode sqlNode) {
        if (sqlNode instanceof SqlSelectBlock) {
            SqlSelectBlock block = (SqlSelectBlock)sqlNode;
            if (block.cols.size() == 0) {
                SqlSelectBlock.calcView(block);
            }
            return (SqlSelectBlock)sqlNode;
        }
        SqlSelectBlock block = SqlSelectBlock._create(request, sqlNode);
        if (block.getCols().size() != 0) {
            throw new SDBInternalError("Can't set a view on Select block which is already had columns set");
        }
        SqlSelectBlock.calcView(block);
        return block;
    }

    private static SqlSelectBlock blockPlain(SDBRequest request, SqlNode sqlNode) {
        if (sqlNode instanceof SqlSelectBlock) {
            return (SqlSelectBlock)sqlNode;
        }
        SqlSelectBlock block = new SqlSelectBlock(sqlNode.getAliasName(), sqlNode);
        return block;
    }

    private static SqlSelectBlock blockNoView(SDBRequest request, SqlNode sqlNode) {
        if (sqlNode instanceof SqlSelectBlock) {
            return (SqlSelectBlock)sqlNode;
        }
        return SqlSelectBlock._create(request, sqlNode);
    }

    private static SqlSelectBlock _create(SDBRequest request, SqlNode sqlNode) {
        String alias = sqlNode.getAliasName();
        alias = request.generator("S").next();
        SqlSelectBlock block = new SqlSelectBlock(alias, sqlNode);
        SqlSelectBlock.addNotes(block, sqlNode);
        return block;
    }

    private static void addNotes(SqlSelectBlock block, SqlNode sqlNode) {
        block.addNotes(sqlNode.getNotes());
    }

    private static void calcView(SqlSelectBlock block) {
        SqlNode sqlNode = block.getSubNode();
        ScopeBase idScopeRename = new ScopeBase();
        ScopeBase nodeScopeRename = new ScopeBase();
        Gensym gen = Gensym.create("X");
        block.merge(sqlNode.getIdScope(), idScopeRename, gen);
        block.merge(sqlNode.getNodeScope(), nodeScopeRename, gen);
        block.nodeScope = nodeScopeRename;
        block.idScope = idScopeRename;
    }

    private void merge(Scope scope, ScopeBase newScope, Generator gen) {
        String x = "";
        String sep = "";
        for (ScopeEntry e : scope.findScopes()) {
            SqlColumn oldCol = e.getColumn();
            Var v = e.getVar();
            String colName = gen.next();
            SqlColumn newCol = new SqlColumn(this.vTable, colName);
            this.add(new ColAlias(oldCol, newCol));
            newScope.setColumnForVar(v, newCol);
            x = String.format("%s%s%s:(%s=>%s)", x, sep, v, oldCol, newCol);
            sep = " ";
        }
        if (x.length() > 0) {
            this.addNote(x);
        }
    }
}

