/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.PrintSerializable;
import com.hp.hpl.jena.sparql.util.QueryOutputUtils;
import java.util.ArrayList;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.io.PrintUtils;
import org.openjena.atlas.io.Printable;
import org.openjena.atlas.iterator.Action;
import org.openjena.atlas.iterator.Iter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadBlock
extends ArrayList<Quad>
implements Iterable<Quad>,
PrintSerializable {
    Node graphNode;
    private static Quad[] qArrayTemplate = new Quad[0];

    public QuadBlock() {
    }

    public QuadBlock(QuadBlock other) {
        super(other);
        this.graphNode = other.graphNode;
    }

    public QuadBlock(OpQuadPattern quadPattern) {
        this.addAll(quadPattern.getPattern().getList());
        this.graphNode = quadPattern.getGraphNode();
    }

    @Override
    public QuadBlock clone() {
        return new QuadBlock(this);
    }

    public Quad[] asArray() {
        return this.toArray(qArrayTemplate);
    }

    public Node getGraphNode() {
        return this.graphNode;
    }

    public boolean contains(Quad pattern) {
        return this.contains(pattern.getGraph(), pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.findFirst(g, s, p, o) >= 0;
    }

    public int findFirst(Quad pattern) {
        return this.findFirst(0, pattern);
    }

    public int findFirst(Node g, Node s, Node p, Node o) {
        return this.findFirst(0, g, s, p, o);
    }

    public int findFirst(int start, Quad pattern) {
        return this.findFirst(start, pattern.getGraph(), pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    public int findFirst(int start, Node g, Node s, Node p, Node o) {
        if (g == Node.ANY) {
            g = null;
        }
        if (s == Node.ANY) {
            s = null;
        }
        if (p == Node.ANY) {
            p = null;
        }
        if (o == Node.ANY) {
            o = null;
        }
        for (int i = start; i < this.size(); ++i) {
            Quad q = (Quad)this.get(i);
            if (!QuadBlock.matchOne(g, s, p, o, q)) continue;
            return i;
        }
        return -1;
    }

    public QuadBlock subBlock(int fromIndex, int toIndex) {
        QuadBlock slice = new QuadBlock();
        slice.addAll(this.subList(fromIndex, toIndex));
        return slice;
    }

    public QuadBlock subBlock(int fromIndex) {
        QuadBlock slice = new QuadBlock();
        slice.addAll(this.subList(fromIndex, this.size()));
        return slice;
    }

    public Iterable<Quad> find(Quad pattern) {
        return this.find(pattern.getGraph(), pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }

    public Iterable<Quad> find(Node g, Node s, Node p, Node o) {
        ArrayList<Quad> matches = new ArrayList<Quad>();
        if (g == Node.ANY) {
            g = null;
        }
        if (s == Node.ANY) {
            s = null;
        }
        if (p == Node.ANY) {
            p = null;
        }
        if (o == Node.ANY) {
            o = null;
        }
        for (Quad q : this) {
            if (!QuadBlock.matchOne(g, s, p, o, q)) continue;
            matches.add(q);
        }
        return matches;
    }

    private static boolean matchOne(Node g, Node s, Node p, Node o, Quad q) {
        return !(p != null && !p.equals((Object)q.getPredicate()) || s != null && !s.equals((Object)q.getSubject()) || o != null && !o.equals((Object)q.getObject()) || g != null && !g.equals((Object)q.getGraph()));
    }

    @Override
    public String toString() {
        return PrintUtils.toString((Printable)this);
    }

    public void output(final IndentedWriter out, SerializationContext sCxt) {
        String sep = "\n";
        Action<Quad> strAction = new Action<Quad>(){
            boolean first = true;

            public void apply(Quad quad) {
                if (!this.first) {
                    out.print((Object)"\n");
                }
                this.first = false;
                out.print((Object)quad);
            }
        };
        Iter.apply((Iterable)this, (Action)strAction);
    }

    public String toString(PrefixMapping prefixMapping) {
        return QueryOutputUtils.toString((PrintSerializable)this, (PrefixMapping)prefixMapping);
    }

    public void output(IndentedWriter out) {
        QueryOutputUtils.output((PrintSerializable)this, (IndentedWriter)out);
    }
}

