/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterDropIterator;
import com.hp.hpl.jena.util.iterator.FilterKeepIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestFilters
extends ModelTestBase {
    protected Filter<String> containsA = new Filter<String>(){

        public boolean accept(String o) {
            return TestFilters.this.contains(o, 'a');
        }
    };

    public TestFilters(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFilters.class);
    }

    public void testFilterAnyExists() {
        TestFilters.assertInstanceOf(Filter.class, Filter.any());
    }

    public void testFilterAnyAcceptsThings() {
        TestFilters.assertTrue((boolean)Filter.any().accept((Object)"hello"));
        TestFilters.assertTrue((boolean)Filter.any().accept((Object)new Integer(17)));
        TestFilters.assertTrue((boolean)Filter.any().accept((Object)TestFilters.node("frodo")));
        TestFilters.assertTrue((boolean)Filter.any().accept((Object)TestFilters.node("_cheshire")));
        TestFilters.assertTrue((boolean)Filter.any().accept((Object)TestFilters.node("17")));
        TestFilters.assertTrue((boolean)Filter.any().accept((Object)TestFilters.triple("s p o")));
        TestFilters.assertTrue((boolean)Filter.any().accept((Object)Filter.any()));
        TestFilters.assertTrue((boolean)Filter.any().accept((Object)this));
    }

    public void testFilterFilterMethod() {
        TestFilters.assertFalse((boolean)Filter.any().filterKeep((Iterator)NullIterator.instance()).hasNext());
    }

    public void testFilteringThings() {
        ExtendedIterator<String> it = TestFilters.iteratorOfStrings("gab geb bag big lava hall end");
        Filter<String> f = new Filter<String>(){

            public boolean accept(String o) {
                return o.charAt(1) == 'a';
            }
        };
        TestFilters.assertEquals(TestFilters.listOfStrings("gab bag lava hall"), TestFilters.iteratorToList(f.filterKeep(it)));
    }

    public void testAnyFilterSimple() {
        ExtendedIterator<String> it = TestFilters.iteratorOfStrings("");
        TestFilters.assertSame(it, (Object)Filter.any().filterKeep(it));
    }

    public void testFilterAnd() {
        Filter<String> containsB = new Filter<String>(){

            public boolean accept(String o) {
                return TestFilters.this.contains(o, 'b');
            }
        };
        Filter f12 = this.containsA.and((Filter)containsB);
        TestFilters.assertFalse((boolean)f12.accept((Object)"a"));
        TestFilters.assertFalse((boolean)f12.accept((Object)"b"));
        TestFilters.assertTrue((boolean)f12.accept((Object)"ab"));
        TestFilters.assertTrue((boolean)f12.accept((Object)"xyzapqrbijk"));
        TestFilters.assertTrue((boolean)f12.accept((Object)"ba"));
    }

    public void testFilterShortcircuit() {
        Filter<String> oops = new Filter<String>(){

            public boolean accept(String o) {
                throw new JenaException("oops");
            }
        };
        Filter f12 = this.containsA.and((Filter)oops);
        TestFilters.assertFalse((boolean)f12.accept((Object)"z"));
        try {
            f12.accept((Object)"a");
            TestFilters.fail((String)"oops");
        }
        catch (JenaException e) {
            TestFilters.assertEquals((String)"oops", (String)e.getMessage());
        }
    }

    public void testAnyAndTrivial() {
        TestFilters.assertSame(this.containsA, (Object)Filter.any().and(this.containsA));
    }

    public void testSomethingAndAny() {
        TestFilters.assertSame(this.containsA, (Object)this.containsA.and(Filter.any()));
    }

    public void testFilterDropIterator() {
        ExtendedIterator<String> i = TestFilters.iteratorOfStrings("there's an a in some animals");
        FilterDropIterator it = new FilterDropIterator(this.containsA, i);
        TestFilters.assertEquals(TestFilters.listOfStrings("there's in some"), TestFilters.iteratorToList(it));
    }

    public void testFilterKeepIterator() {
        ExtendedIterator<String> i = TestFilters.iteratorOfStrings("there's an a in some animals");
        FilterKeepIterator it = new FilterKeepIterator(this.containsA, i);
        TestFilters.assertEquals(TestFilters.listOfStrings("an a animals"), TestFilters.iteratorToList(it));
    }

    protected boolean contains(Object o, char ch) {
        return o.toString().indexOf(ch) > -1;
    }
}

