/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGenericRuleReasonerConfig
extends AssemblerTestBase {
    public TestGenericRuleReasonerConfig(String name) {
        super(name);
    }

    @Override
    protected Model setRequiredPrefixes(Model x) {
        x.setNsPrefix("jr", "http://jena.hpl.hp.com/2003/JenaReasoner#");
        return super.setRequiredPrefixes(x);
    }

    public void testLoadsSingleRuleSetViaURL() {
        this.testLoadsSingleRuleViaURL("jr");
    }

    private void testLoadsSingleRuleViaURL(String ns) {
        String where = "file:testing/modelspecs/example.rules";
        Resource r = this.resourceInModel("x <ns>:ruleSetURL <where>".replaceAll("<ns>", ns).replaceAll("<where>", where));
        List rules = Rule.rulesFromURL((String)where);
        GenericRuleReasoner grr = new GenericRuleReasoner(null, r);
        TestGenericRuleReasonerConfig.assertEquals((Object)rules, (Object)grr.getRules());
    }

    public void testLoadsSingleRuleFromString() {
        this.testLoadsSingleRuleFromString("jr");
    }

    private void testLoadsSingleRuleFromString(String ns) {
        String rule = "[R: (?x rdf:type eg:Thing) -> (?x eg:thing true)]";
        List rules = Rule.parseRules((String)rule);
        Resource r = this.resourceInModel("x <ns>:hasRule '<it>'".replaceAll("<ns>", ns).replaceAll("<it>", rule.replaceAll(" ", "\\\\\\\\s")));
        GenericRuleReasoner grr = new GenericRuleReasoner(null, r);
        TestGenericRuleReasonerConfig.assertEquals((Object)rules, (Object)grr.getRules());
    }

    public void testLoadsSingleRuleViaRuleSetStringString() {
        this.testLoadsRulesViaRuleSetStrings("jr");
    }

    private void testLoadsRulesViaRuleSetStrings(String ns) {
        String ruleA = "[R: (?x rdf:type eg:Thing) -> (?x eg:thing true)]";
        String ruleB = "[S: (?x rdf:type eg:Thung) -> (?x eg:thing false)]";
        Set<Rule> rules = this.rulesFromTwoStrings(ruleA, ruleB);
        String modelString = "x <ns>:ruleSet _x; _x <ns>:hasRule '<A>'; _x <ns>:hasRule '<B>'".replaceAll("<ns>", ns).replaceAll("<A>", ruleA.replaceAll(" ", "\\\\\\\\s")).replaceAll("<B>", ruleB.replaceAll(" ", "\\\\\\\\s"));
        Resource r = this.resourceInModel(modelString);
        GenericRuleReasoner grr = new GenericRuleReasoner(null, r);
        TestGenericRuleReasonerConfig.assertEquals(rules, new HashSet(grr.getRules()));
    }

    public void testLoadsMultipleRuleSetsViaRuleSetNode() {
        this.testLoadsMultipleRuleSetsViaRuleSetNode("jr");
    }

    private void testLoadsMultipleRuleSetsViaRuleSetNode(String ns) {
        String whereA = "file:testing/modelspecs/example.rules";
        String whereB = "file:testing/modelspecs/extra.rules";
        Resource r = this.resourceInModel("x <ns>:ruleSet _a; _a <ns>:ruleSetURL <whereA>; _a <ns>:ruleSetURL <whereB>".replaceAll("<ns>", ns).replaceAll("<whereA>", whereA).replaceAll("<whereB>", whereB));
        GenericRuleReasoner grr = new GenericRuleReasoner(null, r);
        TestGenericRuleReasonerConfig.assertEquals(this.rulesFromTwoPlaces(whereA, whereB), new HashSet(grr.getRules()));
    }

    private Set<Rule> rulesFromTwoStrings(String ruleA, String ruleB) {
        HashSet<Rule> rules = new HashSet<Rule>(Rule.parseRules((String)ruleA));
        rules.addAll(Rule.parseRules((String)ruleB));
        return rules;
    }

    private Set<Rule> rulesFromTwoPlaces(String whereA, String whereB) {
        HashSet<Rule> rules = new HashSet<Rule>();
        rules.addAll(Rule.rulesFromURL((String)whereA));
        rules.addAll(Rule.rulesFromURL((String)whereB));
        return rules;
    }
}

