/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.BFRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingStack;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBasics
extends TestCase {
    private static final int MAX_VARS = 10;
    Node p = Node.createURI((String)"p");
    Node q = Node.createURI((String)"q");
    Node r = Node.createURI((String)"r");
    Node s = Node.createURI((String)"s");
    Node n1 = Node.createURI((String)"n1");
    Node n2 = Node.createURI((String)"n2");
    Node n3 = Node.createURI((String)"n3");
    Node n4 = Node.createURI((String)"n4");
    Node n5 = Node.createURI((String)"n5");
    Node res = Node.createURI((String)"res");

    public TestBasics(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBasics.class);
    }

    public void testRuleParser() {
        String[] testRules = new String[]{"(?a rdf:type ?_) -> (?a rdf:type ?b).", "(?a rdf:type ?_), (?a rdf:type ?_) -> (?a rdf:type ?b).", "(?a rdf:type max(?a,1)) -> (?a rdf:type 'foo').", "(?a rdf:type ?_) -> addOne(?a).", "(?a rdf:type ?_) -> [(?a rdf:type ?_) -> addOne(?a)].", "(?a rdf:type ?_) -> (?a rdf:type '42').", "(?a rdf:type ?_) -> (?a rdf:type 4.2).", "(?a rdf:type ?_) -> (?a rdf:type ' fool that,I(am)').", "[rule1: (?a rdf:type ?_) -> (?a rdf:type a)]", "-> print(' ').", "-> print(' literal with embedded \\' characters ').", "-> print(\" literal characters \").", "-> print(42). ", "-> print('42'^^xsd:byte). ", "-> print('42'^^http://www.w3.org/2001/XMLSchema#int). ", "-> print('42'^^foobar:byte). ", "-> print(<foo://a/file>). "};
        String[] testResults = new String[]{"[ (?a rdf:type ?_) -> (?a rdf:type ?b) ]", "[ (?a rdf:type ?_) (?a rdf:type ?_) -> (?a rdf:type ?b) ]", "[ (?a rdf:type 'max(?a '1'^^http://www.w3.org/2001/XMLSchema#int)'^^urn:x-hp-jena:Functor) -> (?a rdf:type 'foo') ]", "[ (?a rdf:type ?_) -> addOne(?a) ]", "[ (?a rdf:type ?_) -> [ (?a rdf:type ?_) -> addOne(?a) ] ]", "[ (?a rdf:type ?_) -> (?a rdf:type '42') ]", "[ (?a rdf:type ?_) -> (?a rdf:type '4.2'^^http://www.w3.org/2001/XMLSchema#float) ]", "[ (?a rdf:type ?_) -> (?a rdf:type ' fool that,I(am)') ]", "[ rule1: (?a rdf:type ?_) -> (?a rdf:type a) ]", "[ -> print(' ') ]", "[ -> print(' literal with embedded ' characters ') ]", "[ -> print(' literal characters ') ]", "[ -> print('42'^^http://www.w3.org/2001/XMLSchema#int) ]", "[ -> print('42'^^http://www.w3.org/2001/XMLSchema#byte) ]", "[ -> print('42'^^http://www.w3.org/2001/XMLSchema#int) ]", "[ -> print('42'^^http://foobar#byte) ]", "[ -> print(foo://a/file) ]"};
        PrintUtil.registerPrefix((String)"foobar", (String)"http://foobar#");
        for (int i = 0; i < testRules.length; ++i) {
            Rule r = Rule.parseRule((String)testRules[i]);
            TestBasics.assertEquals((String)testResults[i], (String)r.toString());
        }
        String[] testBadRules = new String[]{"(foo(?A) eg:p ?B) <- (?a, eg:p, ?B).", "(foo(?A) eg:p ?B) -> (?a, eg:p, ?B)."};
        for (int i = 0; i < testBadRules.length; ++i) {
            boolean foundError = false;
            try {
                Rule r = Rule.parseRule((String)testBadRules[i]);
            }
            catch (Rule.ParserException e) {
                foundError = true;
            }
            TestBasics.assertTrue((String)"Failed to find illegal rule", (boolean)foundError);
        }
    }

    public void testRuleEquality() {
        Rule r1 = Rule.parseRule((String)"(?a p ?b) -> (?a q ?b).");
        Rule r2 = Rule.parseRule((String)"(?a p ?b) -> (?b q ?a).");
        Rule r1b = Rule.parseRule((String)"(?x p ?y) -> (?x q ?y).");
        Rule r3 = Rule.parseRule((String)"(?a p ?b), addOne(?a) -> (?a q ?b).");
        Rule r3b = Rule.parseRule((String)"(?c p ?d), addOne(?c) -> (?c q ?d).");
        Rule r4 = Rule.parseRule((String)"(?a p ?b), makeTemp(?a) -> (?a q ?b).");
        Rule r5 = Rule.parseRule((String)"(?a p ?b), addOne(?b) -> (?a q ?b).");
        Rule r6 = Rule.parseRule((String)"(?a p ?b), addOne(p) -> (?a q ?b).");
        TestBasics.assertTrue((!r1.equals((Object)r2) ? 1 : 0) != 0);
        TestBasics.assertTrue((boolean)r1.equals((Object)r1b));
        TestBasics.assertTrue((!r1.equals((Object)r3) ? 1 : 0) != 0);
        TestBasics.assertTrue((boolean)r3.equals((Object)r3b));
        TestBasics.assertTrue((!r3.equals((Object)r4) ? 1 : 0) != 0);
        TestBasics.assertTrue((!r3.equals((Object)r5) ? 1 : 0) != 0);
        TestBasics.assertTrue((!r3.equals((Object)r6) ? 1 : 0) != 0);
    }

    public void testBindingEnvironment() {
        BindingStack env = new BindingStack();
        env.reset(10);
        env.bind(3, this.n1);
        TestBasics.assertEquals((Object)this.n1, (Object)env.getEnvironment()[3]);
        env.push();
        env.bind(2, this.n2);
        TestBasics.assertEquals((Object)this.n2, (Object)env.getEnvironment()[2]);
        env.unwind();
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[2]);
        TestBasics.assertEquals((Object)this.n1, (Object)env.getEnvironment()[3]);
        env.push();
        env.bind(1, this.n3);
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[2]);
        TestBasics.assertEquals((Object)this.n1, (Object)env.getEnvironment()[3]);
        TestBasics.assertEquals((Object)this.n3, (Object)env.getEnvironment()[1]);
        env.unwind();
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[2]);
        TestBasics.assertEquals((Object)this.n1, (Object)env.getEnvironment()[3]);
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[1]);
        env.push();
        env.bind(1, this.n3);
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[2]);
        TestBasics.assertEquals((Object)this.n1, (Object)env.getEnvironment()[3]);
        TestBasics.assertEquals((Object)this.n3, (Object)env.getEnvironment()[1]);
        env.commit();
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[2]);
        TestBasics.assertEquals((Object)this.n1, (Object)env.getEnvironment()[3]);
        TestBasics.assertEquals((Object)this.n3, (Object)env.getEnvironment()[1]);
        try {
            env.unwind();
            TestBasics.assertTrue((String)"Failed to catch end of stack", (boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testClauseMaching() {
        BindingStack env = new BindingStack();
        env.reset(10);
        ArrayList rules = new ArrayList();
        BasicForwardRuleInfGraph inf = new BasicForwardRuleInfGraph((Reasoner)new BasicForwardRuleReasoner(rules), rules, null);
        TriplePattern p1 = new TriplePattern((Node)new Node_RuleVariable("?a", 0), this.n1, (Node)new Node_RuleVariable("?b", 1));
        TriplePattern p2 = new TriplePattern((Node)new Node_RuleVariable("?b", 1), (Node)new Node_RuleVariable("?c", 2), this.n2);
        boolean match = FRuleEngine.match((TriplePattern)p1, (Triple)new Triple(this.n1, this.n2, this.n3), (BindingStack)env);
        TestBasics.assertTrue((!match ? 1 : 0) != 0);
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[0]);
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[1]);
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[2]);
        match = FRuleEngine.match((TriplePattern)p1, (Triple)new Triple(this.n2, this.n1, this.n3), (BindingStack)env);
        TestBasics.assertTrue((boolean)match);
        TestBasics.assertEquals((Object)this.n2, (Object)env.getEnvironment()[0]);
        TestBasics.assertEquals((Object)this.n3, (Object)env.getEnvironment()[1]);
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[2]);
        match = FRuleEngine.match((TriplePattern)p2, (Triple)new Triple(this.n1, this.n2, this.n2), (BindingStack)env);
        TestBasics.assertTrue((!match ? 1 : 0) != 0);
        TestBasics.assertEquals((Object)this.n2, (Object)env.getEnvironment()[0]);
        TestBasics.assertEquals((Object)this.n3, (Object)env.getEnvironment()[1]);
        TestBasics.assertEquals(null, (Object)env.getEnvironment()[2]);
        match = FRuleEngine.match((TriplePattern)p2, (Triple)new Triple(this.n3, this.n1, this.n2), (BindingStack)env);
        TestBasics.assertTrue((boolean)match);
        TestBasics.assertEquals((Object)this.n2, (Object)env.getEnvironment()[0]);
        TestBasics.assertEquals((Object)this.n3, (Object)env.getEnvironment()[1]);
        TestBasics.assertEquals((Object)this.n1, (Object)env.getEnvironment()[2]);
    }

    public void testRuleMatcher() {
        String rules = "[r1: (?a p ?b), (?b q ?c) -> (?a, q, ?c)][r2: (?a p ?b), (?b p ?c) -> (?a, p, ?c)][r3: (?a p ?a), (n1 p ?c), (n1, p, ?a) -> (?a, p, ?c)][r4: (n4 ?p ?a) -> (n4, ?a, ?p)]";
        List ruleList = Rule.parseRules((String)rules);
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(Factory.createGraphMem());
        infgraph.add(new Triple(this.n1, this.p, this.n2));
        infgraph.add(new Triple(this.n2, this.p, this.n3));
        infgraph.add(new Triple(this.n2, this.q, this.n3));
        infgraph.add(new Triple(this.n4, this.p, this.n4));
        TestUtil.assertIteratorValues(this, infgraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n2, this.p, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.n4, this.p, this.n4), new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3), new Triple(this.n4, this.n4, this.p)});
    }

    public void testRuleDerivations() {
        String rules = "[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)]";
        List ruleList = Rule.parseRules((String)rules);
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(Factory.createGraphMem());
        infgraph.setDerivationLogging(true);
        infgraph.add(new Triple(this.n1, this.p, this.n3));
        infgraph.add(new Triple(this.n1, this.q, this.n4));
        infgraph.add(new Triple(this.n1, this.q, this.n3));
        TestUtil.assertIteratorValues(this, infgraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
        Iterator derivs = infgraph.getDerivation(new Triple(this.res, this.p, this.n3));
        StringWriter outString = new StringWriter(250);
        PrintWriter out = new PrintWriter(outString);
        while (derivs.hasNext()) {
            Derivation d = (Derivation)derivs.next();
            d.printTrace(out, true);
        }
        out.flush();
        String testString = TestUtil.normalizeWhiteSpace("Rule testRule3 concluded (res p n3) <-\n    Rule testRule1 concluded (n2 p n3) <-\n        Fact (n1 p n3)\r\n    Rule testRule2 concluded (n2 q n3) <-\n        Fact (n1 q n3)\r\n");
        TestBasics.assertEquals((String)testString, (String)TestUtil.normalizeWhiteSpace(outString.getBuffer().toString()));
    }

    public void testAxiomHandling() {
        String rules = "[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)][axiom1: -> (n1 p n3)]";
        List ruleList = Rule.parseRules((String)rules);
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(Factory.createGraphMem());
        TestUtil.assertIteratorValues(this, infgraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3)});
        infgraph.add(new Triple(this.n1, this.q, this.n4));
        infgraph.add(new Triple(this.n1, this.q, this.n3));
        TestUtil.assertIteratorValues(this, infgraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
    }

    public void testSchemaBinding() {
        String rules = "[testRule1: (n1 p ?a) -> (n2, p, ?a)][testRule2: (n1 q ?a) -> (n2, q, ?a)][testRule3: (n2 p ?a), (n2 q ?a) -> (res p ?a)]";
        List ruleList = Rule.parseRules((String)rules);
        Graph schema = Factory.createGraphMem();
        schema.add(new Triple(this.n1, this.p, this.n3));
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.q, this.n4));
        data.add(new Triple(this.n1, this.q, this.n3));
        BasicForwardRuleReasoner reasoner = new BasicForwardRuleReasoner(ruleList);
        Reasoner boundReasoner = reasoner.bindSchema(schema);
        InfGraph infgraph = boundReasoner.bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(null, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n2, this.p, this.n3), new Triple(this.n1, this.q, this.n4), new Triple(this.n2, this.q, this.n4), new Triple(this.n1, this.q, this.n3), new Triple(this.n2, this.q, this.n3), new Triple(this.res, this.p, this.n3)});
    }

    public void testEmbeddedFunctors() {
        String rules = "(?C owl:onProperty ?P), (?C owl:allValuesFrom ?D) -> (?C rb:restriction all(?P, ?D)).(?C rb:restriction all(eg:p, eg:D)) -> (?C rb:restriction 'allOK').[ -> (eg:foo eg:prop functor(eg:bar, 1)) ][ (?x eg:prop functor(eg:bar, ?v)) -> (?x eg:propbar ?v) ][ (?x eg:prop functor(?v, ?*)) -> (?x eg:propfunc ?v) ]";
        List ruleList = Rule.parseRules((String)rules);
        Model data = ModelFactory.createDefaultModel();
        Resource R1 = data.createResource("urn:x-hp:eg/R1");
        Resource D = data.createResource("urn:x-hp:eg/D");
        Property p = data.createProperty("urn:x-hp:eg/", "p");
        Property prop = data.createProperty("urn:x-hp:eg/", "prop");
        Property propbar = data.createProperty("urn:x-hp:eg/", "propbar");
        Property propfunc = data.createProperty("urn:x-hp:eg/", "propfunc");
        Property rbr = data.createProperty("urn:x-hp-jena:rubrik/", "restriction");
        R1.addProperty(OWL.onProperty, (RDFNode)p).addProperty(OWL.allValuesFrom, (RDFNode)D);
        BasicForwardRuleReasoner reasoner = new BasicForwardRuleReasoner(ruleList);
        InfGraph infgraph = reasoner.bind(data.getGraph());
        Model infModel = ModelFactory.createModelForGraph((Graph)infgraph);
        Resource foo = infModel.createResource("urn:x-hp:eg/foo");
        Resource bar = infModel.createResource("urn:x-hp:eg/bar");
        RDFNode flit = infModel.getResource(R1.getURI()).getRequiredProperty(rbr).getObject();
        TestBasics.assertNotNull((Object)flit);
        TestBasics.assertEquals((String)flit.toString(), (String)"allOK");
        Literal one = (Literal)foo.getRequiredProperty(propbar).getObject();
        TestBasics.assertEquals((Object)new Integer(1), (Object)one.getValue());
    }

    public void testBuiltins() {
        String rules = "[r1: (n1 p ?x), addOne(?x, ?y) -> (n1 q ?y)][r2: (n1 p ?x), lessThan(?x, 3) -> (n2 q ?x)][axiom1: -> (n1 p 1)][axiom2: -> (n1 p 4)]";
        List ruleList = Rule.parseRules((String)rules);
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(Factory.createGraphMem());
        TestUtil.assertIteratorValues(this, infgraph.find(this.n1, this.q, null), new Triple[]{new Triple(this.n1, this.q, Util.makeIntNode((int)2)), new Triple(this.n1, this.q, Util.makeIntNode((int)5))});
        TestUtil.assertIteratorValues(this, infgraph.find(this.n2, this.q, null), new Triple[]{new Triple(this.n2, this.q, Util.makeIntNode((int)1))});
    }

    public void testRemoveBuiltin() {
        String rules = "[rule1: (?x p ?y), (?x q ?y) -> remove(0)]";
        List ruleList = Rule.parseRules((String)rules);
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(Factory.createGraphMem());
        infgraph.add(new Triple(this.n1, this.p, Util.makeIntNode((int)1)));
        infgraph.add(new Triple(this.n1, this.p, Util.makeIntNode((int)2)));
        infgraph.add(new Triple(this.n1, this.q, Util.makeIntNode((int)2)));
        TestUtil.assertIteratorValues(this, infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, Util.makeIntNode((int)1)), new Triple(this.n1, this.q, Util.makeIntNode((int)2))});
    }

    public void testDropBuiltin() {
        String rules = "[rule1: (?x p ?y) -> drop(0)]";
        List ruleList = Rule.parseRules((String)rules);
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(Factory.createGraphMem());
        infgraph.add(new Triple(this.n1, this.p, Util.makeIntNode((int)1)));
        infgraph.add(new Triple(this.n1, this.p, Util.makeIntNode((int)2)));
        infgraph.add(new Triple(this.n1, this.q, Util.makeIntNode((int)2)));
        TestUtil.assertIteratorValues(this, infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.q, Util.makeIntNode((int)2))});
    }

    public void testRebind() {
        String rules = "[rule1: (?x p ?y) -> (?x q ?y)]";
        List ruleList = Rule.parseRules((String)rules);
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, this.n2));
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(data);
        TestUtil.assertIteratorValues(this, infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n2), new Triple(this.n1, this.q, this.n2)});
        Graph ndata = Factory.createGraphMem();
        ndata.add(new Triple(this.n1, this.p, this.n3));
        infgraph.rebind(ndata);
        TestUtil.assertIteratorValues(this, infgraph.find(this.n1, null, null), new Triple[]{new Triple(this.n1, this.p, this.n3), new Triple(this.n1, this.q, this.n3)});
    }

    public void testSize() {
        String rules = "[rule1: (?x p ?y) -> (?x q ?y)]";
        List ruleList = Rule.parseRules((String)rules);
        Graph data = Factory.createGraphMem();
        data.add(new Triple(this.n1, this.p, this.n2));
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(data);
        TestBasics.assertEquals((int)infgraph.size(), (int)2);
    }

    public void testValidityReport() {
        StandardValidityReport report = new StandardValidityReport();
        report.add(false, "dummy", "dummy1");
        report.add(false, "dummy", "dummy3");
        TestBasics.assertTrue((boolean)report.isValid());
        report.add(true, "dummy", "dummy2");
        TestBasics.assertTrue((!report.isValid() ? 1 : 0) != 0);
        report = new StandardValidityReport();
        report.add(false, "dummy", "dummy1");
        report.add(true, "dummy", "dummy2");
        report.add(false, "dummy", "dummy3");
        TestBasics.assertTrue((!report.isValid() ? 1 : 0) != 0);
        report = new StandardValidityReport();
        report.add(new ValidityReport.Report(false, "dummy", "dummy1"));
        report.add(new ValidityReport.Report(true, "dummy", "dummy2"));
        report.add(new ValidityReport.Report(false, "dummy", "dummy3"));
        TestBasics.assertTrue((!report.isValid() ? 1 : 0) != 0);
    }

    public void testConvertList() {
        Graph data = Factory.createGraphMem();
        Node first = RDF.Nodes.first;
        Node rest = RDF.Nodes.rest;
        Node nil = RDF.Nodes.nil;
        data.add(new Triple(this.n1, first, this.p));
        data.add(new Triple(this.n1, rest, this.n2));
        data.add(new Triple(this.n2, first, this.q));
        data.add(new Triple(this.n2, rest, nil));
        data.add(new Triple(this.n3, first, this.p));
        data.add(new Triple(this.n3, rest, this.n4));
        data.add(new Triple(this.n4, rest, this.n5));
        data.add(new Triple(this.n5, first, this.q));
        data.add(new Triple(this.n5, rest, nil));
        String rules = "[rule1: (?x p ?y) -> (?x q ?y)]";
        List ruleList = Rule.parseRules((String)rules);
        InfGraph infgraph = new BasicForwardRuleReasoner(ruleList).bind(data);
        BFRuleContext context = new BFRuleContext((ForwardRuleInfGraphI)infgraph);
        List result = Util.convertList((Node)this.n1, (RuleContext)context);
        TestBasics.assertEquals((int)result.size(), (int)2);
        TestBasics.assertEquals(result.get(0), (Object)this.p);
        TestBasics.assertEquals(result.get(1), (Object)this.q);
        List result2 = Util.convertList((Node)this.n3, (RuleContext)context);
        TestBasics.assertEquals((int)result2.size(), (int)1);
        TestBasics.assertEquals(result2.get(0), (Object)this.p);
    }
}

