/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPEventHandler;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.NTriple;
import com.hp.hpl.jena.rdf.arp.impl.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.arp.test.InFactoryX;
import com.hp.hpl.jena.rdf.arp.test.TestScope;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.wg.TestInputStreamFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestSuite;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class NTripleTestSuite
extends WGTestSuite {
    NTripleTestSuite(TestInputStreamFactory fact, String name, boolean b) {
        super(fact, name, b);
    }

    static TestSuite suite(IRI testDir, String d, String nm) {
        return new NTripleTestSuite(new TestInputStreamFactory(testDir, d), nm, true);
    }

    static TestSuite suite(IRI testDir, IRI d, String nm) {
        return new NTripleTestSuite(new TestInputStreamFactory(testDir, d), nm, true);
    }

    Model loadRDF(InFactoryX in, RDFErrorHandler eh, String base) throws IOException {
        return NTripleTestSuite.loadRDFx(in, eh, base, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Model loadRDFx(InFactoryX in, RDFErrorHandler eh, String base, boolean wantModel, int cnt) throws IOException {
        TestHandler th;
        PrintStream out;
        InputStream oldIn = System.in;
        InputStream ntIn = null;
        File ntriples = null;
        if (wantModel) {
            ntriples = File.createTempFile("arp", ".nt");
            out = new PrintStream(new FileOutputStream(ntriples));
            th = new TestHandler(eh);
        } else {
            out = new PrintStream(new OutputStream(){

                public void write(int b) throws IOException {
                }
            });
            th = new TestHandler(eh, cnt);
        }
        PrintStream oldOut = System.out;
        try {
            block13: {
                System.setIn(in.open());
                System.setOut(out);
                try {
                    NTriple.mainEh((String[])new String[]{"-b", base, "-s"}, (ErrorHandler)th, (ARPEventHandler)th);
                }
                catch (SimulatedException e) {
                    if (!wantModel) break block13;
                    throw e;
                }
            }
            out.close();
            th.atEndOfFile();
            if (cnt == 0) {
                for (int i = th.getCount(); i >= 1; --i) {
                    NTripleTestSuite.loadRDFx(in, TestScope.suppress, base, false, i);
                }
            }
            if (wantModel) {
                ntIn = new FileInputStream(ntriples);
                Model model = NTripleTestSuite.loadNT(ntIn, base);
                return model;
            }
            Model model = null;
            return model;
        }
        finally {
            System.in.close();
            System.setIn(oldIn);
            System.setOut(oldOut);
            if (ntIn != null) {
                ntIn.close();
            }
            if (ntriples != null) {
                ntriples.delete();
            }
        }
    }

    static class TestHandler
    extends ARPSaxErrorHandler
    implements ARPEventHandler,
    ErrorHandler {
        final int xCountDown;
        Set<AResource> anon = new HashSet<AResource>();
        Set<AResource> oldAnon = new HashSet<AResource>();
        int state = 1;
        int countDown;
        boolean hasErrors = false;

        TestHandler(RDFErrorHandler eh) {
            this(eh, 0);
        }

        TestHandler(RDFErrorHandler eh, int cnt) {
            super(eh);
            this.countDown = cnt;
            this.xCountDown = cnt;
        }

        public void statement(AResource subj, AResource pred, AResource obj) {
            Assert.assertEquals((int)this.state, (int)2);
            this.seeing(subj);
            this.seeing(obj);
            if (--this.countDown == 0) {
                throw new SimulatedException();
            }
        }

        private void seeing(AResource subj) {
            if (subj.isAnonymous()) {
                this.anon.add(subj);
            }
            Assert.assertFalse((String)"bnode reuse?", (boolean)this.oldAnon.contains(subj));
        }

        private void seen(AResource subj) {
            if (!this.anon.contains(subj)) {
                Assert.assertFalse((String)("end-scope called twice for a bnode: " + subj.getAnonymousID()), (boolean)this.oldAnon.contains(subj));
                Assert.assertTrue((String)("end-scope for a bnode that had not been used " + subj.getAnonymousID()), (boolean)this.anon.contains(subj));
            }
            this.anon.remove(subj);
            this.oldAnon.add(subj);
        }

        public void statement(AResource subj, AResource pred, ALiteral lit) {
            Assert.assertEquals((String)"no start RDF seen", (int)this.state, (int)2);
            this.seeing(subj);
            if (--this.countDown == 0) {
                throw new SimulatedException();
            }
        }

        public void endBNodeScope(AResource bnode) {
            Assert.assertTrue((boolean)bnode.isAnonymous());
            switch (this.state) {
                case 1: {
                    Assert.fail((String)"Missing startRDF");
                    return;
                }
                case 2: {
                    Assert.assertFalse((boolean)bnode.hasNodeID());
                    this.seen(bnode);
                    break;
                }
                case 3: 
                case 4: {
                    Assert.assertTrue((boolean)bnode.hasNodeID());
                    this.seen(bnode);
                    this.state = 4;
                    break;
                }
                default: {
                    Assert.fail((String)"impossible - test logic error");
                }
            }
        }

        public void startRDF() {
            switch (this.state) {
                case 2: 
                case 4: {
                    Assert.fail((String)("Bad state for startRDF " + this.state));
                }
            }
            this.state = 2;
        }

        public void endRDF() {
            Assert.assertEquals((int)this.state, (int)2);
            this.state = 3;
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void atEndOfFile() {
            if (!this.anon.isEmpty()) {
                for (AResource a : this.anon) {
                    System.err.print(a.getAnonymousID() + ", ");
                }
            }
            Assert.assertTrue((String)("(" + this.xCountDown + ") some bnode still in scope "), (boolean)this.anon.isEmpty());
            switch (this.state) {
                case 1: {
                    Assert.fail((String)"end-of-file before anything");
                    return;
                }
                case 2: {
                    Assert.fail((String)"did not see endRDF");
                    return;
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    Assert.fail((String)"impossible logic error in test");
                }
            }
        }

        public void error(SAXParseException exception) throws SAXException {
            this.hasErrors = true;
            super.error(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.hasErrors = true;
            super.fatalError(exception);
        }

        public int getCount() {
            return -this.countDown;
        }

        public boolean discardNodesWithNodeID() {
            return false;
        }
    }

    static class SimulatedException
    extends RuntimeException {
        private static final long serialVersionUID = -4804213791508445759L;

        SimulatedException() {
        }
    }
}

