/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestAllDifferent
extends OntTestBase {
    public static TestSuite suite() {
        return new TestAllDifferent("TestAllDifferent");
    }

    public TestAllDifferent(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("AllDifferent.distinctMembers", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                AllDifferent a = m.createAllDifferent();
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(OntResource.class);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(OntResource.class);
                a.addDistinctMember((Resource)b);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.DISTINCT_MEMBERS()));
                1.assertEquals((String)"List size should be 1", (int)1, (int)a.getDistinctMembers().size());
                1.assertTrue((String)"a should have b as distinct", (boolean)a.hasDistinctMember((Resource)b));
                a.addDistinctMember((Resource)c);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.DISTINCT_MEMBERS()));
                1.assertEquals((String)"List size should be 2", (int)2, (int)a.getDistinctMembers().size());
                this.iteratorTest((Iterator<?>)a.listDistinctMembers(), new Object[]{b, c});
                1.assertTrue((String)"a should have b as distinct", (boolean)a.hasDistinctMember((Resource)b));
                1.assertTrue((String)"a should have c as distinct", (boolean)a.hasDistinctMember((Resource)c));
                a.setDistinctMembers(m.createList(new RDFNode[]{b}));
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)a.getCardinality(prof.DISTINCT_MEMBERS()));
                1.assertEquals((String)"List size should be 1", (int)1, (int)a.getDistinctMembers().size());
                1.assertTrue((String)"a should have b as distinct", (boolean)a.hasDistinctMember((Resource)b));
                1.assertTrue((String)"a should not have c as distinct", (!a.hasDistinctMember((Resource)c) ? 1 : 0) != 0);
                a.removeDistinctMember((Resource)b);
                1.assertTrue((String)"a should have not b as distinct", (!a.hasDistinctMember((Resource)b) ? 1 : 0) != 0);
            }
        }};
    }
}

