/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTestGraph
extends AbstractTestGraph {
    protected final Class<? extends Graph> graphClass;
    protected final ReificationStyle style;

    public MetaTestGraph(Class<? extends Graph> graphClass, String name, ReificationStyle style) {
        super(name);
        this.graphClass = graphClass;
        this.style = style;
    }

    public MetaTestGraph(String name) {
        super(name);
        this.graphClass = null;
        this.style = null;
    }

    public static TestSuite suite() {
        return MetaTestGraph.suite(MetaTestGraph.class, GraphMem.class, ReificationStyle.Minimal);
    }

    public static TestSuite suite(Class<? extends Test> testClass, Class<? extends Graph> graphClass) {
        TestSuite result = new TestSuite();
        result.addTest((Test)MetaTestGraph.suite(testClass, graphClass, ReificationStyle.Minimal));
        result.addTest((Test)MetaTestGraph.suite(testClass, graphClass, ReificationStyle.Standard));
        result.addTest((Test)MetaTestGraph.suite(testClass, graphClass, ReificationStyle.Convenient));
        return result;
    }

    public static TestSuite suite(Class<? extends Test> testClass, Class<? extends Graph> graphClass, ReificationStyle style) {
        TestSuite result = new TestSuite();
        Class<? extends Test> c = testClass;
        while (Test.class.isAssignableFrom(c)) {
            Method[] methods = c.getDeclaredMethods();
            MetaTestGraph.addTestMethods(result, testClass, methods, graphClass, style);
            c = c.getSuperclass();
        }
        return result;
    }

    public static void addTestMethods(TestSuite result, Class<? extends Test> testClass, Method[] methods, Class<? extends Graph> graphClass, ReificationStyle style) {
        for (int i = 0; i < methods.length; ++i) {
            if (!MetaTestGraph.isPublicTestMethod(methods[i])) continue;
            result.addTest((Test)MetaTestGraph.makeTest(testClass, graphClass, methods[i].getName(), style));
        }
    }

    public static TestCase makeTest(Class<? extends Test> testClass, Class<? extends Graph> graphClass, String name, ReificationStyle style) {
        Constructor<?> cons = MetaTestGraph.getConstructor(testClass, new Class[]{Class.class, String.class, ReificationStyle.class});
        if (cons == null) {
            throw new JenaException("cannot find MetaTestGraph constructor");
        }
        try {
            return (TestCase)cons.newInstance(graphClass, name, style);
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    @Override
    public Graph getGraph() {
        return MetaTestGraph.getGraph((Object)this, this.graphClass, this.style);
    }
}

