/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.ReifierTripleMap;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import java.util.Iterator;

public abstract class AbstractTestReifierTripleMap
extends GraphTestBase {
    protected ReifierTripleMap tripleMap = this.getTripleMap();
    protected static final Triple triple_xRy = AbstractTestReifierTripleMap.triple("x R y");
    protected static final Triple triple_aRb = AbstractTestReifierTripleMap.triple("a R b");
    protected static final Node nodeA = AbstractTestReifierTripleMap.node("a");
    protected static final Node nodeB = AbstractTestReifierTripleMap.node("b");
    protected static final Node nodeC = AbstractTestReifierTripleMap.node("c");

    public AbstractTestReifierTripleMap(String name) {
        super(name);
    }

    protected abstract ReifierTripleMap getTripleMap();

    public void testEmptyMap() {
        AbstractTestReifierTripleMap.assertEquals(null, (Object)this.tripleMap.getTriple(nodeA));
        AbstractTestReifierTripleMap.assertEquals(null, (Object)this.tripleMap.getTriple(nodeB));
        AbstractTestReifierTripleMap.assertEquals((boolean)false, (boolean)this.tripleMap.hasTriple(triple_xRy));
        AbstractTestReifierTripleMap.assertEquals((boolean)false, (boolean)this.tripleMap.tagIterator().hasNext());
        AbstractTestReifierTripleMap.assertEquals((boolean)false, (boolean)this.tripleMap.tagIterator(triple_aRb).hasNext());
        AbstractTestReifierTripleMap.assertFalse((boolean)this.tripleMap.find((TripleMatch)Triple.ANY).hasNext());
    }

    public void testPutTriple_hasTriple() {
        this.tripleMap.putTriple(nodeA, triple_xRy);
        AbstractTestReifierTripleMap.assertEquals((boolean)true, (boolean)this.tripleMap.hasTriple(triple_xRy));
        AbstractTestReifierTripleMap.assertEquals((boolean)false, (boolean)this.tripleMap.hasTriple(AbstractTestReifierTripleMap.triple("x R z")));
    }

    public void testPutTriple_getTriple() {
        this.tripleMap.putTriple(nodeA, triple_xRy);
        AbstractTestReifierTripleMap.assertEquals((Object)triple_xRy, (Object)this.tripleMap.getTriple(nodeA));
        AbstractTestReifierTripleMap.assertEquals(null, (Object)this.tripleMap.getTriple(nodeB));
    }

    public void testPutTriple_tagIterator() {
        this.tripleMap.putTriple(nodeA, triple_xRy);
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("a"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator()));
    }

    public void testPutTriple_tagIteratorT() {
        this.tripleMap.putTriple(nodeA, triple_xRy);
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("a"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_xRy)));
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet(""), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(AbstractTestReifierTripleMap.triple("x S y"))));
    }

    public void testPutTriples_hasTriple() {
        this.put_xRy_and_aRb();
        AbstractTestReifierTripleMap.assertEquals((boolean)true, (boolean)this.tripleMap.hasTriple(triple_xRy));
        AbstractTestReifierTripleMap.assertEquals((boolean)true, (boolean)this.tripleMap.hasTriple(triple_aRb));
    }

    public void testPutTriples_getTriple() {
        this.put_xRy_and_aRb();
        AbstractTestReifierTripleMap.assertEquals((Object)triple_xRy, (Object)this.tripleMap.getTriple(nodeA));
        AbstractTestReifierTripleMap.assertEquals((Object)triple_aRb, (Object)this.tripleMap.getTriple(nodeB));
    }

    public void testPutTriples_tagIterator() {
        this.put_xRy_and_aRb();
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("a b"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator()));
    }

    public void testPutTriples_tagIteratorT() {
        this.put_xRy_and_aRb();
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("a"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_xRy)));
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("b"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_aRb)));
    }

    public void testMultipleTagging() {
        this.tripleMap.putTriple(nodeA, triple_xRy);
        this.tripleMap.putTriple(nodeB, triple_xRy);
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("a b"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_xRy)));
    }

    public void testRemoveTriplesByTag() {
        this.put_xRy_and_aRb();
        this.tripleMap.removeTriple(nodeA);
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("b"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator()));
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("b"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_aRb)));
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet(""), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_xRy)));
    }

    public void testRemoveTaggedTriple() {
        this.put_xRy_and_aRb();
        this.tripleMap.removeTriple(nodeA, triple_xRy);
        AbstractTestReifierTripleMap.assertEquals(null, (Object)this.tripleMap.getTriple(nodeA));
        AbstractTestReifierTripleMap.assertEquals((Object)triple_aRb, (Object)this.tripleMap.getTriple(nodeB));
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("b"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_aRb)));
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet(""), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_xRy)));
    }

    public void testRemoveTripleDirectly() {
        this.put_xRy_and_aRb();
        this.tripleMap.putTriple(nodeC, triple_xRy);
        this.tripleMap.removeTriple(triple_xRy);
        AbstractTestReifierTripleMap.assertEquals(null, (Object)this.tripleMap.getTriple(nodeA));
        AbstractTestReifierTripleMap.assertEquals(null, (Object)this.tripleMap.getTriple(nodeC));
        AbstractTestReifierTripleMap.assertEquals((Object)triple_aRb, (Object)this.tripleMap.getTriple(nodeB));
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet("b"), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_aRb)));
        AbstractTestReifierTripleMap.assertEquals((Object)this.nodeSet(""), (Object)AbstractTestReifierTripleMap.iteratorToSet((Iterator)this.tripleMap.tagIterator(triple_xRy)));
    }

    protected void put_xRy_and_aRb() {
        this.tripleMap.putTriple(nodeA, triple_xRy);
        this.tripleMap.putTriple(nodeB, triple_aRb);
    }
}

