/*
 * (c) Copyright 2010 Epimorphics Ltd.
 * All rights reserved.
 * [See end of file]
 */

package com.hp.hpl.jena.sparql.modify;



import com.hp.hpl.jena.sparql.engine.binding.Binding ;
import com.hp.hpl.jena.sparql.modify.submission.UpdateProcessorSubmission ;
import com.hp.hpl.jena.sparql.modify.submission.UpdateSubmission ;
import com.hp.hpl.jena.sparql.util.Context ;
import com.hp.hpl.jena.update.GraphStore ;
import com.hp.hpl.jena.update.Update ;
import com.hp.hpl.jena.update.UpdateRequest ;

public class UpdateEngineMain extends UpdateEngineBase 
{
    public UpdateEngineMain(GraphStore graphStore, UpdateRequest request, Binding initialBinding, Context context)
    {
        super(graphStore, request, initialBinding, context) ;
    }

    @Override
    public void execute()
    {
        graphStore.startRequest() ;
        UpdateEngineWorker worker = new UpdateEngineWorker(graphStore, startBinding) ;
        for ( Update up : request.getOperations() )
        {
            if ( up instanceof UpdateSubmission )
            {
                // If old style, go there.
                executeUpdateSubmission((UpdateSubmission)up) ;
                continue ;
            }
            up.visit(worker) ;
        }
        graphStore.finishRequest() ;
    }
    
    public void executeUpdateSubmission(UpdateSubmission ups)
    {
        UpdateProcessorSubmission p = 
            new UpdateProcessorSubmission(graphStore, null, super.startBinding) ;
        p.execute(ups) ;
    }
    
    private static UpdateEngineFactory factory = new UpdateEngineFactory()
    {
        public boolean accept(UpdateRequest request, GraphStore graphStore, Context context)
        {
            return true ;
        }

        public UpdateEngine create(UpdateRequest request, GraphStore graphStore, Binding inputBinding, Context context)
        {
            return new UpdateEngineMain(graphStore, request, inputBinding, context) ;
        }
    } ;


    public static UpdateEngineFactory getFactory() { return factory ; }
}

/*
 * (c) Copyright 2010 Epimorphics Ltd.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */