/*
 * (c) Copyright 2006, 2007, 2008, 2009 Hewlett-Packard Development Company, LP
 * All rights reserved.
 * [See end of file]
 */

package com.hp.hpl.jena.sparql.algebra;

import java.util.List ;

import com.hp.hpl.jena.sparql.algebra.op.* ;

public interface Transform
{
    // Op0
    public Op transform(OpTable opUnit) ;
    public Op transform(OpBGP opBGP) ;
    public Op transform(OpTriple opTriple) ;
    public Op transform(OpPath opPath) ;
    public Op transform(OpDatasetNames dsNames) ;
    public Op transform(OpQuadPattern quadPattern) ;
    public Op transform(OpNull opNull) ;
    
    // Op1
    public Op transform(OpFilter opFilter, Op subOp) ;
    public Op transform(OpGraph opGraph, Op subOp) ;
    public Op transform(OpService opService, Op subOp) ;
    public Op transform(OpProcedure opProcedure, Op subOp) ;
    public Op transform(OpPropFunc opPropFunc, Op subOp) ;
    public Op transform(OpLabel opLabel, Op subOp) ;
    public Op transform(OpAssign opAssign, Op subOp) ;
    public Op transform(OpExtend opExtend, Op subOp) ;

    // Op2
    public Op transform(OpJoin opJoin, Op left, Op right) ;
    public Op transform(OpLeftJoin opLeftJoin, Op left, Op right) ;
    public Op transform(OpDiff opDiff, Op left, Op right) ;
    public Op transform(OpMinus opMinus, Op left, Op right) ;
    public Op transform(OpUnion opUnion, Op left, Op right) ;
    public Op transform(OpConditional opCondition, Op left, Op right) ;
    
    // OpN
    public Op transform(OpSequence opSequence, List<Op> elts) ;
    public Op transform(OpDisjunction opDisjunction, List<Op> elts) ;

    // Extensions
    public Op transform(OpExt opExt) ;
    
    // OpModifier
    public Op transform(OpList opList, Op subOp) ;
    public Op transform(OpOrder opOrder, Op subOp) ;
    public Op transform(OpProject opProject, Op subOp) ;
    public Op transform(OpDistinct opDistinct, Op subOp) ;
    public Op transform(OpReduced opReduced, Op subOp) ;
    public Op transform(OpSlice opSlice, Op subOp) ;
    
    public Op transform(OpGroup opGroup, Op subOp) ;
}

/*
 * (c) Copyright 2006, 2007, 2008, 2009 Hewlett-Packard Development Company, LP
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */