/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphWrapper;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.graph.NodeTransformLib;
import com.hp.hpl.jena.sparql.modify.NodeTransformBNodesToVariables;
import com.hp.hpl.jena.sparql.modify.UpdateEngine;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateAdd;
import com.hp.hpl.jena.sparql.modify.request.UpdateClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateCopy;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.request.UpdateDropClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.modify.request.UpdateMove;
import com.hp.hpl.jena.sparql.modify.request.UpdateVisitor;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.MultiMap;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateEngineWorker
implements UpdateVisitor {
    private final GraphStore graphStore;
    private final Binding initialBinding;
    private final boolean alwaysSilent = true;

    UpdateEngineWorker(GraphStore graphStore, Binding initialBinding) {
        this.graphStore = graphStore;
        this.initialBinding = initialBinding;
    }

    @Override
    public void visit(UpdateDrop update2) {
        this.execDropClear(update2, false);
    }

    @Override
    public void visit(UpdateClear update2) {
        this.execDropClear(update2, true);
    }

    private void execDropClear(UpdateDropClear update2, boolean isClear) {
        if (update2.isAll()) {
            this.execDropClear(update2, null, true);
            this.execDropClearAllNamed(update2, isClear);
        } else if (update2.isAllNamed()) {
            this.execDropClearAllNamed(update2, isClear);
        } else if (update2.isDefault()) {
            this.execDropClear(update2, null, true);
        } else if (update2.isOneGraph()) {
            this.execDropClear(update2, update2.getGraph(), isClear);
        } else {
            throw new ARQInternalErrorException("Target is undefined: " + update2.getTarget());
        }
    }

    private void execDropClear(UpdateDropClear update2, Node g, boolean isClear) {
        if (isClear) {
            UpdateEngineWorker.graph(this.graphStore, g).getBulkUpdateHandler().removeAll();
        } else {
            this.graphStore.removeGraph(g);
        }
    }

    private void execDropClearAllNamed(UpdateDropClear update2, boolean isClear) {
        List<Node> list = Iter.toList(this.graphStore.listGraphNodes());
        for (Node gn : list) {
            this.execDropClear(update2, gn, isClear);
        }
    }

    @Override
    public void visit(UpdateCreate update2) {
        Node g = update2.getGraph();
        if (g == null) {
            return;
        }
        if (this.graphStore.containsGraph(g)) {
            return;
        }
        this.graphStore.addGraph(g, GraphFactory.createDefaultGraph());
    }

    @Override
    public void visit(UpdateLoad update2) {
        String source = update2.getSource();
        Node dest = update2.getDest();
        Graph g = UpdateEngineWorker.graph(this.graphStore, dest);
        Model model = ModelFactory.createModelForGraph((Graph)g);
        FileManager.get().readModel(model, source);
    }

    @Override
    public void visit(UpdateAdd update2) {
        UpdateEngineWorker.gsCopyTriples(this.graphStore, update2.getSrc(), update2.getDest());
    }

    @Override
    public void visit(UpdateCopy update2) {
        UpdateEngineWorker.gsCopy(this.graphStore, update2.getSrc(), update2.getDest());
    }

    @Override
    public void visit(UpdateMove update2) {
        UpdateEngineWorker.gsCopy(this.graphStore, update2.getSrc(), update2.getDest());
        UpdateEngineWorker.gsDrop(this.graphStore, update2.getSrc(), true);
    }

    private static void gsCopy(GraphStore gStore, Target src, Target dest) {
        UpdateEngineWorker.gsClear(gStore, dest, true);
        UpdateEngineWorker.gsCopyTriples(gStore, src, dest);
    }

    private static void gsCopyTriples(GraphStore gStore, Target src, Target dest) {
        Graph gSrc = UpdateEngineWorker.graph(gStore, src);
        Graph gDest = UpdateEngineWorker.graph(gStore, dest);
        List list = Iter.toList(gSrc.find(null, null, null));
        gDest.getBulkUpdateHandler().add(list);
    }

    private static void gsClear(GraphStore gStore, Target target, boolean isSilent) {
        Graph g = UpdateEngineWorker.graph(gStore, target);
        if (target.isOneNamedGraph() && !gStore.containsGraph(target.getGraph())) {
            if (!isSilent) {
                UpdateEngineWorker.error("No such graph: " + g);
            }
            return;
        }
        g.getBulkUpdateHandler().removeAll();
    }

    private static void gsDrop(GraphStore gStore, Target target, boolean isSilent) {
        if (target.isDefault()) {
            gStore.getDefaultGraph().getBulkUpdateHandler().removeAll();
        } else {
            gStore.removeGraph(target.getGraph());
        }
    }

    @Override
    public void visit(UpdateDataInsert update2) {
        for (Quad quad : update2.getQuads()) {
            this.graphStore.add(quad);
        }
    }

    @Override
    public void visit(UpdateDataDelete update2) {
        for (Quad quad : update2.getQuads()) {
            this.graphStore.delete(quad);
        }
    }

    @Override
    public void visit(UpdateDeleteWhere update2) {
        List<Quad> quads = update2.getQuads();
        quads = UpdateEngineWorker.convertBNodesToVariables(quads);
        Element el = this.elementFromQuads(quads);
        List<Binding> bindings = this.evalBindings(el, null);
        this.execDelete(quads, null, bindings);
    }

    @Override
    public void visit(UpdateModify update2) {
        Node graph = update2.getWithIRI();
        Query query2 = this.elementToQuery(update2.getWherePattern());
        this.processUsing(update2, query2);
        List<Binding> bindings = this.evalBindings(query2, graph);
        this.execDelete(update2.getDeleteQuads(), graph, bindings);
        this.execInsert(update2.getInsertQuads(), graph, bindings);
    }

    protected void processUsing(UpdateModify update2, Query query2) {
        if (update2.getUsing().size() > 0 || update2.getUsingNamed().size() > 0) {
            Log.warn(this, "Graph selection from the dataset not supported - ignored");
        }
    }

    private static List<Quad> convertBNodesToVariables(List<Quad> quads) {
        NodeTransformBNodesToVariables bnodesToVariables = new NodeTransformBNodesToVariables();
        return NodeTransformLib.transformQuads(bnodesToVariables, quads);
    }

    private Element elementFromQuads(List<Quad> quads) {
        ElementGroup el = new ElementGroup();
        ElementTriplesBlock x = new ElementTriplesBlock();
        el.addElement(x);
        Node g = Quad.defaultGraphNodeGenerated;
        for (Quad q : quads) {
            if (q.getGraph() != g) {
                g = q.getGraph();
                x = new ElementTriplesBlock();
                if (g == null || g == Quad.defaultGraphNodeGenerated) {
                    el.addElement(x);
                } else {
                    ElementNamedGraph eng = new ElementNamedGraph(g, x);
                    el.addElement(eng);
                }
            }
            x.addTriple(q.asTriple());
        }
        return el;
    }

    private MultiMap<Node, Triple> execBase(List<Quad> quads, final Node dftGraph, List<Binding> bindings) {
        if (quads == null || quads.isEmpty()) {
            return null;
        }
        if (dftGraph != null) {
            Transform<Quad, Quad> nt = new Transform<Quad, Quad>(){

                @Override
                public Quad convert(Quad quad) {
                    if (!quad.isDefaultGraph()) {
                        return quad;
                    }
                    return new Quad(dftGraph, quad.getSubject(), quad.getPredicate(), quad.getObject());
                }
            };
            quads = Iter.map(quads, nt);
        }
        MultiMap<Node, Triple> acc = this.calcTriples(quads, bindings);
        return acc;
    }

    private void execDelete(List<Quad> quads, Node dftGraph, List<Binding> bindings) {
        MultiMap<Node, Triple> acc = this.execBase(quads, dftGraph, bindings);
        if (acc == null) {
            return;
        }
        for (Node gn : acc.keys()) {
            Collection<Triple> triples = acc.get(gn);
            UpdateEngineWorker.graph(this.graphStore, gn).getBulkUpdateHandler().delete(triples.iterator());
        }
    }

    private void execInsert(List<Quad> quads, Node dftGraph, List<Binding> bindings) {
        MultiMap<Node, Triple> acc = this.execBase(quads, dftGraph, bindings);
        if (acc == null) {
            return;
        }
        for (Node gn : acc.keys()) {
            Collection<Triple> triples = acc.get(gn);
            UpdateEngineWorker.graph(this.graphStore, gn).getBulkUpdateHandler().add(triples.iterator());
        }
    }

    private MultiMap<Node, Triple> calcTriples(List<Quad> quads, List<Binding> bindings) {
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bindings.iterator());
        return UpdateEngineWorker.subst(quads, qIter);
    }

    protected static MultiMap<Node, Triple> subst(List<Quad> quads, QueryIterator qIter) {
        MultiMap<Node, Triple> acc = MultiMap.createMapList();
        while (qIter.hasNext()) {
            HashMap<Node, Node> bNodeMap = new HashMap<Node, Node>();
            Binding b = qIter.nextBinding();
            for (Quad quad : quads) {
                UpdateEngineWorker.subst(acc, quad, b, bNodeMap);
            }
        }
        return acc;
    }

    private static void subst(MultiMap<Node, Triple> acc, Quad quad, Binding b, Map<Node, Node> bNodeMap) {
        Quad q = UpdateEngineWorker.subst(quad, b, bNodeMap);
        if (!q.isConcrete()) {
            Log.warn(UpdateEngine.class, "Unbound quad: " + FmtUtils.stringForQuad(quad));
            return;
        }
        acc.put(q.getGraph(), q.asTriple());
    }

    private static Quad subst(Quad quad, Binding b, Map<Node, Node> bNodeMap) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g1 = g;
        Node s1 = s;
        Node p1 = p;
        Node o1 = o;
        if (g1.isBlank()) {
            g1 = UpdateEngineWorker.newBlank(g1, bNodeMap);
        }
        if (s1.isBlank()) {
            s1 = UpdateEngineWorker.newBlank(s1, bNodeMap);
        }
        if (p1.isBlank()) {
            p1 = UpdateEngineWorker.newBlank(p1, bNodeMap);
        }
        if (o1.isBlank()) {
            o1 = UpdateEngineWorker.newBlank(o1, bNodeMap);
        }
        Quad q = quad;
        if (s1 != s || p1 != p || o1 != o || g1 != g) {
            q = new Quad(g1, s1, p1, o1);
        }
        Quad q2 = Substitute.substitute(q, b);
        return q2;
    }

    private static Node newBlank(Node n, Map<Node, Node> bNodeMap) {
        if (!bNodeMap.containsKey(n)) {
            bNodeMap.put(n, Node.createAnon());
        }
        return bNodeMap.get(n);
    }

    private Query elementToQuery(Element pattern) {
        if (pattern == null) {
            return null;
        }
        Query query2 = new Query();
        query2.setQueryPattern(pattern);
        query2.setQuerySelectType();
        query2.setQueryResultStar(true);
        query2.setResultVars();
        return query2;
    }

    protected List<Binding> evalBindings(Element pattern, Node dftGraph) {
        return this.evalBindings(this.elementToQuery(pattern), dftGraph);
    }

    protected List<Binding> evalBindings(Query query2, Node dftGraph) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (query2 != null) {
            DatasetGraph dsg = this.graphStore;
            if (dftGraph != null) {
                Graph g = dsg.getGraph(dftGraph);
                dsg = new DatasetGraphAltDefaultGraph(dsg, g);
            }
            Plan plan = QueryExecutionFactory.createPlan(query2, dsg, this.initialBinding);
            QueryIterator qIter = plan.iterator();
            while (qIter.hasNext()) {
                Binding b = qIter.nextBinding();
                bindings.add(b);
            }
            qIter.close();
        } else if (this.initialBinding != null) {
            bindings.add(this.initialBinding);
        } else {
            bindings.add(BindingRoot.create());
        }
        return bindings;
    }

    private static Graph graph(GraphStore graphStore, Node gn) {
        if (gn == null || gn == Quad.defaultGraphNodeGenerated) {
            return graphStore.getDefaultGraph();
        }
        return graphStore.getGraph(gn);
    }

    private static Graph graph(GraphStore graphStore, Target target) {
        if (target.isDefault()) {
            return graphStore.getDefaultGraph();
        }
        if (target.isOneNamedGraph()) {
            return UpdateEngineWorker.graph(graphStore, target.getGraph());
        }
        UpdateEngineWorker.error("Target does not name one graph: " + target);
        return null;
    }

    private static void error(String msg) {
        throw new UpdateException(msg);
    }

    static class DatasetGraphAltDefaultGraph
    extends DatasetGraphWrapper {
        private Graph dftGraph;

        public DatasetGraphAltDefaultGraph(DatasetGraph dsg, Graph dftGraph) {
            super(dsg);
            this.setDefaultGraph(dftGraph);
        }

        public Graph getDefaultGraph() {
            return this.dftGraph;
        }

        public void setDefaultGraph(Graph g) {
            this.dftGraph = g;
        }
    }
}

