/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraphBase;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatasetGraphBaseFind
extends DatasetGraphBase {
    protected DatasetGraphBaseFind() {
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        if (!DatasetGraphBaseFind.isWildcard(g)) {
            if (Quad.isDefaultGraph(g)) {
                return this.findInDftGraph(s, p, o);
            }
            Iterator<Quad> qIter = this.findInSpecificNamedGraph(g, s, p, o);
            if (qIter == null) {
                return Iter.nullIterator();
            }
            return qIter;
        }
        return this.findAny(s, p, o);
    }

    protected Iterator<Quad> findAny(Node s, Node p, Node o) {
        Iterator<Quad> iter1 = this.findInDftGraph(s, p, o);
        Iterator<Quad> iter2 = this.findInAnyNamedGraphs(s, p, o);
        if (iter1 == null && iter2 == null) {
            return Iter.nullIterator();
        }
        return Iter.append(iter1, iter2);
    }

    protected abstract Iterator<Quad> findInDftGraph(Node var1, Node var2, Node var3);

    protected abstract Iterator<Quad> findInSpecificNamedGraph(Node var1, Node var2, Node var3, Node var4);

    protected abstract Iterator<Quad> findInAnyNamedGraphs(Node var1, Node var2, Node var3);
}

