/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.TranslationTable;

public class Syntax
extends Symbol {
    public static final Syntax syntaxSPARQL_10 = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_10");
    public static final Syntax syntaxSPARQL_11;
    private static final Syntax syntaxSPARQL_11_Update;
    public static Syntax defaultSyntax;
    public static Syntax defaultQuerySyntax;
    public static Syntax defaultUpdateSyntax;
    public static final Syntax syntaxSPARQL;
    private static final Syntax syntaxSPARQL_Update;
    public static final Syntax syntaxARQ;
    public static final Syntax syntaxARQ_Update;
    public static final Syntax syntaxRDQL;
    public static final Syntax syntaxAlgebra;
    public static TranslationTable<Syntax> querySyntaxNames;
    public static TranslationTable<Syntax> updateSyntaxNames;

    protected Syntax(String s) {
        super(s);
    }

    protected Syntax(Syntax s) {
        super(s);
    }

    public static Syntax make(String uri) {
        if (uri == null) {
            return null;
        }
        Symbol sym = Symbol.create(uri);
        if (sym.equals(syntaxARQ)) {
            return syntaxARQ;
        }
        if (sym.equals(syntaxRDQL)) {
            return syntaxRDQL;
        }
        if (sym.equals(syntaxSPARQL)) {
            return syntaxSPARQL;
        }
        if (sym.equals(syntaxSPARQL_10)) {
            return syntaxSPARQL_10;
        }
        if (sym.equals(syntaxSPARQL_11)) {
            return syntaxSPARQL_11;
        }
        if (sym.equals(syntaxAlgebra)) {
            return syntaxAlgebra;
        }
        return null;
    }

    public static Syntax guessFileSyntax(String url) {
        return Syntax.guessFileSyntax(url, syntaxSPARQL);
    }

    public static Syntax guessFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".arq")) {
            return syntaxARQ;
        }
        if (url.endsWith(".rq")) {
            return syntaxSPARQL;
        }
        if (url.endsWith(".aru")) {
            return syntaxARQ_Update;
        }
        if (url.endsWith(".ru")) {
            return syntaxSPARQL_Update;
        }
        if (url.endsWith(".rdql")) {
            return syntaxRDQL;
        }
        if (url.endsWith(".sse")) {
            return syntaxAlgebra;
        }
        return defaultSyntax;
    }

    public static Syntax guessQueryFileSyntax(String url) {
        return Syntax.guessFileSyntax(url, defaultQuerySyntax);
    }

    public static Syntax guessQueryFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".arq")) {
            return syntaxARQ;
        }
        if (url.endsWith(".rq")) {
            return syntaxSPARQL;
        }
        if (url.endsWith(".rdql")) {
            return syntaxRDQL;
        }
        if (url.endsWith(".sse")) {
            return syntaxAlgebra;
        }
        return defaultSyntax;
    }

    public static Syntax guessUpdateFileSyntax(String url) {
        return Syntax.guessUpdateFileSyntax(url, defaultUpdateSyntax);
    }

    public static Syntax guessUpdateFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".aru")) {
            return syntaxARQ_Update;
        }
        if (url.endsWith(".ru")) {
            return syntaxSPARQL_Update;
        }
        if (url.endsWith(".sse")) {
            return syntaxAlgebra;
        }
        return defaultSyntax;
    }

    public static Syntax lookup(String s) {
        return querySyntaxNames.lookup(s);
    }

    static {
        syntaxSPARQL_11_Update = syntaxSPARQL_11 = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_11");
        defaultSyntax = syntaxSPARQL_11;
        defaultQuerySyntax = syntaxSPARQL_11;
        defaultUpdateSyntax = syntaxSPARQL_11_Update;
        syntaxSPARQL = syntaxSPARQL_11;
        syntaxSPARQL_Update = syntaxSPARQL_11_Update;
        syntaxARQ_Update = syntaxARQ = new Syntax("http://jena.hpl.hp.com/2003/07/query/ARQ");
        syntaxRDQL = new Syntax("http://jena.hpl.hp.com/2003/07/query/RDQL");
        syntaxAlgebra = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_Algebra");
        querySyntaxNames = new TranslationTable(true);
        querySyntaxNames.put("sparql", syntaxSPARQL);
        querySyntaxNames.put("sparql_10", syntaxSPARQL_10);
        querySyntaxNames.put("sparql_11", syntaxSPARQL_11);
        querySyntaxNames.put("arq", syntaxARQ);
        querySyntaxNames.put("rdql", syntaxRDQL);
        querySyntaxNames.put("alg", syntaxAlgebra);
        querySyntaxNames.put("op", syntaxAlgebra);
        updateSyntaxNames = new TranslationTable(true);
        querySyntaxNames.put("sparql", syntaxSPARQL_Update);
        querySyntaxNames.put("sparql_11", syntaxSPARQL_11_Update);
        querySyntaxNames.put("arq", syntaxARQ);
    }
}

