/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.tokens;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.vocabulary.XSD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.Pair;
import org.openjena.riot.PrefixMap;
import org.openjena.riot.Prologue;
import org.openjena.riot.RiotException;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.TokenizerText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Token {
    private TokenType tokenType = null;
    private String tokenImage = null;
    private String tokenImage2 = null;
    private Token subToken = null;
    public int cntrlCode = 0;
    private long column;
    private long line;
    static final String delim1 = "";
    static final String delim2 = "";

    public final TokenType getType() {
        return this.tokenType;
    }

    public final String getImage() {
        return this.tokenImage;
    }

    public final String getImage2() {
        return this.tokenImage2;
    }

    public final int getCntrlCode() {
        return this.cntrlCode;
    }

    public final Token getSubToken() {
        return this.subToken;
    }

    public final Token setType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public final Token setImage(String tokenImage) {
        this.tokenImage = tokenImage;
        return this;
    }

    public final Token setImage2(String tokenImage2) {
        this.tokenImage2 = tokenImage2;
        return this;
    }

    public final Token setCntrlCode(int cntrlCode) {
        this.cntrlCode = cntrlCode;
        return this;
    }

    public final Token setSubToken(Token subToken) {
        this.subToken = subToken;
        return this;
    }

    static Token create(String s) {
        PeekReader pr = PeekReader.readString(s);
        TokenizerText tt = new TokenizerText(pr);
        if (!tt.hasNext()) {
            throw new RiotException("No token");
        }
        Token t = tt.next();
        if (tt.hasNext()) {
            throw new RiotException("Extraneous charcaters");
        }
        return t;
    }

    static Iter<Token> createN(String s) {
        PeekReader pr = PeekReader.readString(s);
        TokenizerText tt = new TokenizerText(pr);
        ArrayList<Token> x = new ArrayList<Token>();
        while (tt.hasNext()) {
            x.add(tt.next());
        }
        return Iter.iter(x);
    }

    public long getColumn() {
        return this.column;
    }

    public long getLine() {
        return this.line;
    }

    private Token(TokenType type) {
        this(type, null, null, null);
    }

    private Token(TokenType type, String image1) {
        this(type, image1, null, null);
    }

    private Token(TokenType type, String image1, String image2) {
        this(type, image1, image2, null);
    }

    private Token(TokenType type, String image1, Token subToken) {
        this(type, image1, null, subToken);
    }

    private Token(TokenType type, String image1, String image2, Token subToken) {
        this();
        this.setType(type);
        this.setImage(image1);
        this.setImage2(image2);
        this.setSubToken(subToken);
    }

    private Token() {
        this(-1L, -1L);
    }

    public Token(long line, long column) {
        this.line = line;
        this.column = column;
    }

    public Token(Token token) {
        this.tokenType = token.tokenType;
        this.tokenImage = token.tokenImage;
        this.tokenImage2 = token.tokenImage2;
        this.cntrlCode = token.cntrlCode;
        this.line = token.line;
        this.column = token.column;
    }

    public long asLong() {
        return this.asLong(-1L);
    }

    public long asLong(long dft) {
        switch (this.tokenType) {
            case INTEGER: {
                return Long.valueOf(this.tokenImage);
            }
            case HEX: {
                return Long.valueOf(this.tokenImage, 16);
            }
        }
        return dft;
    }

    public String asWord() {
        if (!this.hasType(TokenType.KEYWORD)) {
            return null;
        }
        return this.getImage();
    }

    public String text() {
        return this.toString(false);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean addLocation) {
        StringBuilder sb = new StringBuilder();
        if (addLocation && this.getLine() >= 0L && this.getColumn() >= 0L) {
            sb.append(String.format("[%d,%d]", this.getLine(), this.getColumn()));
        }
        sb.append("[");
        if (this.getType() == null) {
            sb.append("null");
        } else {
            sb.append(this.getType().toString());
        }
        if (this.getImage() != null) {
            sb.append(":");
            sb.append("");
            sb.append(this.getImage());
            sb.append("");
            if (this.getImage2() != null) {
                sb.append(":");
                sb.append("");
                sb.append(this.getImage2());
                sb.append("");
            }
            if (this.getSubToken() != null) {
                sb.append(";");
                sb.append("");
                sb.append(this.getSubToken().toString());
                sb.append("");
            }
        }
        if (this.getCntrlCode() != 0) {
            sb.append(":");
            sb.append(this.getCntrlCode());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isEOF() {
        return this.tokenType == TokenType.EOF;
    }

    public boolean isCtlCode() {
        return this.tokenType == TokenType.CNTRL;
    }

    public boolean isWord() {
        return this.tokenType == TokenType.KEYWORD;
    }

    public boolean isString() {
        switch (this.tokenType) {
            case STRING: 
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumber() {
        switch (this.tokenType) {
            case INTEGER: 
            case DECIMAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isNode() {
        switch (this.tokenType) {
            case INTEGER: 
            case STRING: 
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: 
            case DECIMAL: 
            case DOUBLE: 
            case BNODE: 
            case IRI: 
            case PREFIXED_NAME: 
            case LITERAL_DT: 
            case LITERAL_LANG: {
                return true;
            }
        }
        return false;
    }

    public boolean isNodeBasic() {
        switch (this.tokenType) {
            case STRING1: 
            case STRING2: 
            case BNODE: 
            case IRI: 
            case PREFIXED_NAME: 
            case LITERAL_DT: 
            case LITERAL_LANG: {
                return true;
            }
        }
        return false;
    }

    public boolean isBasicLiteral() {
        switch (this.tokenType) {
            case STRING: 
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: 
            case LITERAL_DT: 
            case LITERAL_LANG: {
                return true;
            }
        }
        return false;
    }

    public boolean isInteger() {
        return this.tokenType.equals((Object)TokenType.INTEGER);
    }

    public boolean isIRI() {
        return this.tokenType.equals((Object)TokenType.IRI) || this.tokenType.equals((Object)TokenType.PREFIXED_NAME);
    }

    public boolean isBNode() {
        return this.tokenType.equals((Object)TokenType.BNODE);
    }

    public Node asNode() {
        switch (this.tokenType) {
            case BNODE: {
                return Node.createAnon((AnonId)new AnonId(this.tokenImage));
            }
            case IRI: {
                return Node.createURI((String)this.tokenImage);
            }
            case PREFIXED_NAME: {
                return Node.createURI((String)("urn:prefixed-name:" + this.tokenImage + ":" + this.tokenImage2));
            }
            case DECIMAL: {
                return Node.createLiteral((String)this.tokenImage, null, (RDFDatatype)XSDDatatype.XSDdecimal);
            }
            case DOUBLE: {
                return Node.createLiteral((String)this.tokenImage, null, (RDFDatatype)XSDDatatype.XSDdouble);
            }
            case INTEGER: {
                return Node.createLiteral((String)this.tokenImage, null, (RDFDatatype)XSDDatatype.XSDinteger);
            }
            case LITERAL_DT: {
                Node n = this.getSubToken().asNode();
                if (!n.isURI()) {
                    throw new RiotException("Invalid token: " + this);
                }
                RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(n.getURI());
                return Node.createLiteral((String)this.tokenImage, null, (RDFDatatype)dt);
            }
            case LITERAL_LANG: {
                return Node.createLiteral((String)this.tokenImage, (String)this.tokenImage2, null);
            }
            case STRING: 
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: {
                return Node.createLiteral((String)this.tokenImage);
            }
        }
        return null;
    }

    public boolean hasType(TokenType tokenType) {
        return this.getType() == tokenType;
    }

    public int hashCode() {
        return Utils.hashCodeObject((Object)this.tokenType) ^ Utils.hashCodeObject(this.tokenImage) ^ Utils.hashCodeObject(this.tokenImage2) ^ Utils.hashCodeObject(this.cntrlCode);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Token)) {
            return false;
        }
        Token t = (Token)other;
        return Utils.equal((Object)this.tokenType, (Object)t.tokenType) && Utils.equal(this.tokenImage, t.tokenImage) && Utils.equal(this.tokenImage2, t.tokenImage2) && Utils.equal(this.cntrlCode, t.cntrlCode);
    }

    public static Token tokenForChar(char character) {
        switch (character) {
            case '.': {
                return new Token(TokenType.DOT);
            }
            case ';': {
                return new Token(TokenType.SEMICOLON);
            }
            case ',': {
                return new Token(TokenType.COMMA);
            }
            case '{': {
                return new Token(TokenType.LBRACE);
            }
            case '}': {
                return new Token(TokenType.RBRACE);
            }
            case '(': {
                return new Token(TokenType.LPAREN);
            }
            case ')': {
                return new Token(TokenType.RPAREN);
            }
            case '[': {
                return new Token(TokenType.LBRACKET);
            }
            case ']': {
                return new Token(TokenType.RBRACKET);
            }
        }
        throw new RuntimeException("Token error: unrecognized charcater: " + character);
    }

    public static Token tokenForInteger(long value) {
        return new Token(TokenType.INTEGER, Long.toString(value));
    }

    public static Token tokenForWord(String word) {
        return new Token(TokenType.KEYWORD, word);
    }

    public static Token tokenForNode(Node n) {
        return Token.tokenForNode(n, null, null);
    }

    public static Token tokenForNode(Node n, Prologue prologue) {
        return Token.tokenForNode(n, prologue.getBaseURI(), prologue.getPrefixMap());
    }

    public static Token tokenForNode(Node n, String base, PrefixMap mapping) {
        if (n.isURI()) {
            String x;
            Pair<String, String> pname;
            String uri = n.getURI();
            if (mapping != null && (pname = mapping.abbrev(uri)) != null) {
                return new Token(TokenType.PREFIXED_NAME, pname.getLeft(), pname.getRight());
            }
            if (base != null && (x = FmtUtils.abbrevByBase(uri, base)) != null) {
                return new Token(TokenType.IRI, x);
            }
            return new Token(TokenType.IRI, n.getURI());
        }
        if (n.isBlank()) {
            return new Token(TokenType.BNODE, n.getBlankNodeLabel());
        }
        if (n.isVariable()) {
            return new Token(TokenType.VAR, n.getName());
        }
        if (n.isLiteral()) {
            String datatype = n.getLiteralDatatypeURI();
            String lang = n.getLiteralLanguage();
            String s = n.getLiteralLexicalForm();
            if (datatype != null) {
                if (datatype.equals(XSD.integer.getURI())) {
                    try {
                        String s1 = s;
                        if (s.startsWith("+")) {
                            s1 = s.substring(1);
                        }
                        new BigInteger(s1);
                        return new Token(TokenType.INTEGER, s);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (datatype.equals(XSD.decimal.getURI()) && s.indexOf(46) > 0) {
                    try {
                        new BigDecimal(s);
                        return new Token(TokenType.DECIMAL, s);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (datatype.equals(XSD.xdouble.getURI()) && (s.indexOf(101) >= 0 || s.indexOf(69) >= 0)) {
                    try {
                        Double.parseDouble(s);
                        return new Token(TokenType.DOUBLE, s);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                Node dt = Node.createURI((String)datatype);
                Token subToken = Token.tokenForNode(dt);
                return new Token(TokenType.LITERAL_DT, s, subToken);
            }
            if (lang != null && lang.length() > 0) {
                return new Token(TokenType.LITERAL_LANG, s, lang);
            }
            return new Token(TokenType.STRING, s);
        }
        throw new IllegalArgumentException();
    }
}

