/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import org.openjena.atlas.io.BufferingWriter;
import org.openjena.atlas.lib.Chars;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Prologue;
import org.openjena.riot.out.OutputLangUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkTripleOutput
implements Sink<Triple> {
    private CharsetEncoder encoder = Chars.charsetASCII.newEncoder();
    private Prologue prologue = null;
    private BufferingWriter out;
    private Node lastS = null;
    private Node lastP = null;
    private Node lastO = null;

    public SinkTripleOutput(OutputStream outs) {
        this(outs, null);
    }

    public SinkTripleOutput(OutputStream outs, Prologue prologue) {
        BufferingWriter.SinkOutputStream dest = new BufferingWriter.SinkOutputStream(outs);
        this.out = new BufferingWriter(dest);
        this.setPrologue(prologue);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void send(Triple triple) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        OutputLangUtils.output((Writer)this.out, s, this.prologue);
        this.out.output(" ");
        OutputLangUtils.output((Writer)this.out, p, this.prologue);
        this.out.output(" ");
        OutputLangUtils.output((Writer)this.out, o, this.prologue);
        this.out.output(" .");
        this.out.output("\n");
        this.out.flush();
    }

    @Override
    public void close() {
        this.flush();
    }
}

