/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.Sync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkQuadsToDataset
implements Sink<Quad> {
    private final DatasetGraph dataset;
    private Node graphNode = null;
    private Graph graph = null;

    public SinkQuadsToDataset(DatasetGraph dataset) {
        this.dataset = dataset;
    }

    @Override
    public void send(Quad quad) {
        if (this.graph == null || !Utils.equal(quad.getGraph(), this.graphNode)) {
            this.graphNode = quad.getGraph();
            this.graph = quad.isTriple() ? this.dataset.getDefaultGraph() : this.dataset.getGraph(this.graphNode);
        }
        this.graph.add(quad.asTriple());
    }

    @Override
    public void flush() {
        if (this.dataset instanceof Sync) {
            ((Sync)((Object)this.dataset)).sync();
        }
    }

    @Override
    public void close() {
    }
}

