/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.ParserProfile;
import org.openjena.riot.lang.LangTurtleBase;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangTurtle
extends LangTurtleBase<Triple> {
    public LangTurtle(String baseURI, Tokenizer tokens, ParserProfile profile, Sink<Triple> sink) {
        super(baseURI, tokens, profile, sink);
        this.setCurrentGraph(null);
    }

    @Override
    public Lang getLang() {
        return Lang.TURTLE;
    }

    @Override
    protected final void oneTopLevelElement() {
        this.triplesSameSubject();
    }

    @Override
    protected void expectEndOfTriples() {
        this.expectOrEOF("Triples not terminated by DOT", TokenType.DOT);
    }

    @Override
    protected void emit(Node subject, Node predicate, Node object) {
        Triple t = this.profile.createTriple(subject, predicate, object, this.currLine, this.currCol);
        this.sink.send(t);
    }
}

