/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import java.util.Iterator;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.ParserProfile;
import org.openjena.riot.lang.LangBase;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LangNTuple<X>
extends LangBase<X>
implements Iterator<X> {
    private static Logger log = LoggerFactory.getLogger(LangNTuple.class);
    public static final boolean STRICT = false;
    protected boolean skipOnBadTerm = false;

    protected LangNTuple(Tokenizer tokens, ParserProfile profile, Sink<X> sink) {
        super(tokens, sink, profile);
    }

    @Override
    protected final void runParser() {
        while (this.hasNext()) {
            X x = this.parseOne();
            if (x == null) continue;
            this.sink.send(x);
        }
    }

    @Override
    public final boolean hasNext() {
        return super.moreTokens();
    }

    @Override
    public final X next() {
        return this.parseOne();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract X parseOne();

    protected void skipOne(X object, String printForm, long line, long col) {
        this.profile.getHandler().warning("Skip: " + printForm, line, col);
    }

    protected abstract Node tokenAsNode(Token var1);

    protected final void checkIRIOrBNode(Token token) {
        if (token.hasType(TokenType.IRI)) {
            return;
        }
        if (token.hasType(TokenType.BNODE)) {
            return;
        }
        this.exception(token, "Expected BNode or IRI: Got: %s", token);
    }

    protected final void checkIRI(Token token) {
        if (token.hasType(TokenType.IRI)) {
            return;
        }
        this.exception(token, "Expected IRI: Got: %s", token);
    }

    protected final void checkRDFTerm(Token token) {
        switch (token.getType()) {
            case IRI: 
            case BNODE: 
            case STRING2: 
            case LITERAL_DT: 
            case LITERAL_LANG: {
                return;
            }
            case STRING1: {
                break;
            }
            default: {
                this.exception(token, "Illegal object: %s", token);
            }
        }
    }

    public boolean getSkipOnBadTerm() {
        return this.skipOnBadTerm;
    }

    public void setSkipOnBadTerm(boolean skipOnBadTerm) {
        this.skipOnBadTerm = skipOnBadTerm;
    }
}

